package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageListBuilder extends ImageListFluentImpl<ImageListBuilder> implements VisitableBuilder<ImageList,io.fabric8.openshift.api.model.ImageListBuilder>{
  public ImageListBuilder() {
    this(false);
  }
  public ImageListBuilder(Boolean validationEnabled) {
    this(new ImageList(), validationEnabled);
  }
  public ImageListBuilder(ImageListFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageListBuilder(io.fabric8.openshift.api.model.ImageListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageList(), validationEnabled);
  }
  public ImageListBuilder(io.fabric8.openshift.api.model.ImageListFluent<?> fluent,io.fabric8.openshift.api.model.ImageList instance) {
    this(fluent, instance, false);
  }
  public ImageListBuilder(io.fabric8.openshift.api.model.ImageListFluent<?> fluent,io.fabric8.openshift.api.model.ImageList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageListBuilder(io.fabric8.openshift.api.model.ImageList instance) {
    this(instance,false);
  }
  public ImageListBuilder(io.fabric8.openshift.api.model.ImageList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageList build() {
    ImageList buildable = new ImageList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}