package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageSourcePathBuilder extends ImageSourcePathFluentImpl<ImageSourcePathBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ImageSourcePath,io.fabric8.openshift.api.model.ImageSourcePathBuilder>{
  public ImageSourcePathBuilder() {
    this(false);
  }
  public ImageSourcePathBuilder(Boolean validationEnabled) {
    this(new ImageSourcePath(), validationEnabled);
  }
  public ImageSourcePathBuilder(ImageSourcePathFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageSourcePathBuilder(io.fabric8.openshift.api.model.ImageSourcePathFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageSourcePath(), validationEnabled);
  }
  public ImageSourcePathBuilder(io.fabric8.openshift.api.model.ImageSourcePathFluent<?> fluent,io.fabric8.openshift.api.model.ImageSourcePath instance) {
    this(fluent, instance, false);
  }
  public ImageSourcePathBuilder(io.fabric8.openshift.api.model.ImageSourcePathFluent<?> fluent,io.fabric8.openshift.api.model.ImageSourcePath instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDestinationDir(instance.getDestinationDir()); 
    fluent.withSourcePath(instance.getSourcePath()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageSourcePathBuilder(io.fabric8.openshift.api.model.ImageSourcePath instance) {
    this(instance,false);
  }
  public ImageSourcePathBuilder(io.fabric8.openshift.api.model.ImageSourcePath instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDestinationDir(instance.getDestinationDir()); 
    this.withSourcePath(instance.getSourcePath()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageSourcePathFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageSourcePath build() {
    ImageSourcePath buildable = new ImageSourcePath(fluent.getDestinationDir(),fluent.getSourcePath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}