package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamBuilder extends ImageStreamFluentImpl<ImageStreamBuilder> implements VisitableBuilder<ImageStream,io.fabric8.openshift.api.model.ImageStreamBuilder>{
  public ImageStreamBuilder() {
    this(false);
  }
  public ImageStreamBuilder(Boolean validationEnabled) {
    this(new ImageStream(), validationEnabled);
  }
  public ImageStreamBuilder(ImageStreamFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamBuilder(io.fabric8.openshift.api.model.ImageStreamFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageStream(), validationEnabled);
  }
  public ImageStreamBuilder(io.fabric8.openshift.api.model.ImageStreamFluent<?> fluent,io.fabric8.openshift.api.model.ImageStream instance) {
    this(fluent, instance, false);
  }
  public ImageStreamBuilder(io.fabric8.openshift.api.model.ImageStreamFluent<?> fluent,io.fabric8.openshift.api.model.ImageStream instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamBuilder(io.fabric8.openshift.api.model.ImageStream instance) {
    this(instance,false);
  }
  public ImageStreamBuilder(io.fabric8.openshift.api.model.ImageStream instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageStreamFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageStream build() {
    ImageStream buildable = new ImageStream(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}