package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamImageBuilder extends ImageStreamImageFluentImpl<ImageStreamImageBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ImageStreamImage,ImageStreamImageBuilder>{
  public ImageStreamImageBuilder() {
    this(false);
  }
  public ImageStreamImageBuilder(Boolean validationEnabled) {
    this(new ImageStreamImage(), validationEnabled);
  }
  public ImageStreamImageBuilder(io.fabric8.openshift.api.model.ImageStreamImageFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamImageBuilder(io.fabric8.openshift.api.model.ImageStreamImageFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageStreamImage(), validationEnabled);
  }
  public ImageStreamImageBuilder(io.fabric8.openshift.api.model.ImageStreamImageFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamImage instance) {
    this(fluent, instance, false);
  }
  public ImageStreamImageBuilder(io.fabric8.openshift.api.model.ImageStreamImageFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamImage instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withImage(instance.getImage()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamImageBuilder(io.fabric8.openshift.api.model.ImageStreamImage instance) {
    this(instance,false);
  }
  public ImageStreamImageBuilder(io.fabric8.openshift.api.model.ImageStreamImage instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withImage(instance.getImage()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageStreamImageFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageStreamImage build() {
    ImageStreamImage buildable = new ImageStreamImage(fluent.getApiVersion(),fluent.getImage(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}