package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageStreamImageFluentImpl<A extends ImageStreamImageFluent<A>> extends BaseFluent<A> implements ImageStreamImageFluent<A>{
  public ImageStreamImageFluentImpl() {
  }
  public ImageStreamImageFluentImpl(io.fabric8.openshift.api.model.ImageStreamImage instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withImage(instance.getImage()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private ImageBuilder image;
  private java.lang.String kind;
  private ObjectMetaBuilder metadata;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * This method has been deprecated, please use method buildImage instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.openshift.api.model.Image getImage() {
    return this.image!=null ?this.image.build():null;
  }
  public io.fabric8.openshift.api.model.Image buildImage() {
    return this.image!=null ?this.image.build():null;
  }
  public A withImage(io.fabric8.openshift.api.model.Image image) {
    _visitables.get("image").remove(this.image);
    if (image!=null){ this.image= new io.fabric8.openshift.api.model.ImageBuilder(image); _visitables.get("image").add(this.image);} return (A) this;
  }
  public java.lang.Boolean hasImage() {
    return this.image != null;
  }
  public ImageStreamImageFluent.ImageNested<A> withNewImage() {
    return new ImageStreamImageFluentImpl.ImageNestedImpl();
  }
  public ImageStreamImageFluent.ImageNested<A> withNewImageLike(io.fabric8.openshift.api.model.Image item) {
    return new ImageStreamImageFluentImpl.ImageNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ImageStreamImageFluent.ImageNested<A> editImage() {
    return withNewImageLike(getImage());
  }
  public io.fabric8.openshift.api.model.ImageStreamImageFluent.ImageNested<A> editOrNewImage() {
    return withNewImageLike(getImage() != null ? getImage(): new io.fabric8.openshift.api.model.ImageBuilder().build());
  }
  public io.fabric8.openshift.api.model.ImageStreamImageFluent.ImageNested<A> editOrNewImageLike(io.fabric8.openshift.api.model.Image item) {
    return withNewImageLike(getImage() != null ? getImage(): item);
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ImageStreamImageFluent.MetadataNested<A> withNewMetadata() {
    return new ImageStreamImageFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageStreamImageFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new io.fabric8.openshift.api.model.ImageStreamImageFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ImageStreamImageFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.openshift.api.model.ImageStreamImageFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.openshift.api.model.ImageStreamImageFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImageStreamImageFluentImpl that = (ImageStreamImageFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (image != null ? !image.equals(that.image) :that.image != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  image,  kind,  metadata,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ImageNestedImpl<N> extends ImageFluentImpl<ImageStreamImageFluent.ImageNested<N>> implements ImageStreamImageFluent.ImageNested<N>,Nested<N>{
    ImageNestedImpl(io.fabric8.openshift.api.model.Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageBuilder builder;
    public N and() {
      return (N) ImageStreamImageFluentImpl.this.withImage(builder.build());
    }
    public N endImage() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ImageStreamImageFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.ImageStreamImageFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) ImageStreamImageFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}