package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageStreamImportSpecFluentImpl<A extends ImageStreamImportSpecFluent<A>> extends BaseFluent<A> implements ImageStreamImportSpecFluent<A>{
  public ImageStreamImportSpecFluentImpl() {
  }
  public ImageStreamImportSpecFluentImpl(io.fabric8.openshift.api.model.ImageStreamImportSpec instance) {
    this.withImages(instance.getImages()); 
    this.withImport(instance.getImport()); 
    this.withRepository(instance.getRepository()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<ImageImportSpecBuilder> images = new java.util.ArrayList<ImageImportSpecBuilder>();
  private Boolean _import;
  private RepositoryImportSpecBuilder repository;
  private Map<String,Object> additionalProperties;
  public A addToImages(Integer index,io.fabric8.openshift.api.model.ImageImportSpec item) {
    if (this.images == null) {this.images = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageImportSpecBuilder>();}
    io.fabric8.openshift.api.model.ImageImportSpecBuilder builder = new io.fabric8.openshift.api.model.ImageImportSpecBuilder(item);_visitables.get("images").add(index >= 0 ? index : _visitables.get("images").size(), builder);this.images.add(index >= 0 ? index : images.size(), builder); return (A)this;
  }
  public A setToImages(java.lang.Integer index,io.fabric8.openshift.api.model.ImageImportSpec item) {
    if (this.images == null) {this.images = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageImportSpecBuilder>();}
    io.fabric8.openshift.api.model.ImageImportSpecBuilder builder = new io.fabric8.openshift.api.model.ImageImportSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("images").size()) { _visitables.get("images").add(builder); } else { _visitables.get("images").set(index, builder);}
    if (index < 0 || index >= images.size()) { images.add(builder); } else { images.set(index, builder);}
     return (A)this;
  }
  public A addToImages(io.fabric8.openshift.api.model.ImageImportSpec... items) {
    if (this.images == null) {this.images = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageImportSpecBuilder>();}
    for (io.fabric8.openshift.api.model.ImageImportSpec item : items) {io.fabric8.openshift.api.model.ImageImportSpecBuilder builder = new io.fabric8.openshift.api.model.ImageImportSpecBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  public A addAllToImages(Collection<io.fabric8.openshift.api.model.ImageImportSpec> items) {
    if (this.images == null) {this.images = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageImportSpecBuilder>();}
    for (io.fabric8.openshift.api.model.ImageImportSpec item : items) {io.fabric8.openshift.api.model.ImageImportSpecBuilder builder = new io.fabric8.openshift.api.model.ImageImportSpecBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  public A removeFromImages(io.fabric8.openshift.api.model.ImageImportSpec... items) {
    for (io.fabric8.openshift.api.model.ImageImportSpec item : items) {io.fabric8.openshift.api.model.ImageImportSpecBuilder builder = new io.fabric8.openshift.api.model.ImageImportSpecBuilder(item);_visitables.get("images").remove(builder);if (this.images != null) {this.images.remove(builder);}} return (A)this;
  }
  public A removeAllFromImages(java.util.Collection<io.fabric8.openshift.api.model.ImageImportSpec> items) {
    for (io.fabric8.openshift.api.model.ImageImportSpec item : items) {io.fabric8.openshift.api.model.ImageImportSpecBuilder builder = new io.fabric8.openshift.api.model.ImageImportSpecBuilder(item);_visitables.get("images").remove(builder);if (this.images != null) {this.images.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImages(Predicate<io.fabric8.openshift.api.model.ImageImportSpecBuilder> predicate) {
    if (images == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.ImageImportSpecBuilder> each = images.iterator();
    final List visitables = _visitables.get("images");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.ImageImportSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImages instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.openshift.api.model.ImageImportSpec> getImages() {
    return images != null ? build(images) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.ImageImportSpec> buildImages() {
    return images != null ? build(images) : null;
  }
  public io.fabric8.openshift.api.model.ImageImportSpec buildImage(java.lang.Integer index) {
    return this.images.get(index).build();
  }
  public io.fabric8.openshift.api.model.ImageImportSpec buildFirstImage() {
    return this.images.get(0).build();
  }
  public io.fabric8.openshift.api.model.ImageImportSpec buildLastImage() {
    return this.images.get(images.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.ImageImportSpec buildMatchingImage(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageImportSpecBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ImageImportSpecBuilder item: images) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingImage(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageImportSpecBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ImageImportSpecBuilder item: images) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImages(java.util.List<io.fabric8.openshift.api.model.ImageImportSpec> images) {
    if (this.images != null) { _visitables.get("images").removeAll(this.images);}
    if (images != null) {this.images = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.ImageImportSpec item : images){this.addToImages(item);}} else { this.images = null;} return (A) this;
  }
  public A withImages(io.fabric8.openshift.api.model.ImageImportSpec... images) {
    if (this.images != null) {this.images.clear();}
    if (images != null) {for (io.fabric8.openshift.api.model.ImageImportSpec item :images){ this.addToImages(item);}} return (A) this;
  }
  public java.lang.Boolean hasImages() {
    return images != null && !images.isEmpty();
  }
  public ImageStreamImportSpecFluent.ImagesNested<A> addNewImage() {
    return new ImageStreamImportSpecFluentImpl.ImagesNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.ImagesNested<A> addNewImageLike(io.fabric8.openshift.api.model.ImageImportSpec item) {
    return new ImageStreamImportSpecFluentImpl.ImagesNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.ImagesNested<A> setNewImageLike(java.lang.Integer index,io.fabric8.openshift.api.model.ImageImportSpec item) {
    return new io.fabric8.openshift.api.model.ImageStreamImportSpecFluentImpl.ImagesNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.ImagesNested<A> editImage(java.lang.Integer index) {
    if (images.size() <= index) throw new RuntimeException("Can't edit images. Index exceeds size.");
    return setNewImageLike(index, buildImage(index));
  }
  public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.ImagesNested<A> editFirstImage() {
    if (images.size() == 0) throw new RuntimeException("Can't edit first images. The list is empty.");
    return setNewImageLike(0, buildImage(0));
  }
  public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.ImagesNested<A> editLastImage() {
    int index = images.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last images. The list is empty.");
    return setNewImageLike(index, buildImage(index));
  }
  public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.ImagesNested<A> editMatchingImage(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageImportSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<images.size();i++) { 
    if (predicate.test(images.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching images. No match found.");
    return setNewImageLike(index, buildImage(index));
  }
  public java.lang.Boolean getImport() {
    return this._import;
  }
  public A withImport(java.lang.Boolean _import) {
    this._import=_import; return (A) this;
  }
  public java.lang.Boolean hasImport() {
    return this._import != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRepository instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.RepositoryImportSpec getRepository() {
    return this.repository!=null ?this.repository.build():null;
  }
  public io.fabric8.openshift.api.model.RepositoryImportSpec buildRepository() {
    return this.repository!=null ?this.repository.build():null;
  }
  public A withRepository(io.fabric8.openshift.api.model.RepositoryImportSpec repository) {
    _visitables.get("repository").remove(this.repository);
    if (repository!=null){ this.repository= new RepositoryImportSpecBuilder(repository); _visitables.get("repository").add(this.repository);} return (A) this;
  }
  public java.lang.Boolean hasRepository() {
    return this.repository != null;
  }
  public ImageStreamImportSpecFluent.RepositoryNested<A> withNewRepository() {
    return new ImageStreamImportSpecFluentImpl.RepositoryNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.RepositoryNested<A> withNewRepositoryLike(io.fabric8.openshift.api.model.RepositoryImportSpec item) {
    return new io.fabric8.openshift.api.model.ImageStreamImportSpecFluentImpl.RepositoryNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.RepositoryNested<A> editRepository() {
    return withNewRepositoryLike(getRepository());
  }
  public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.RepositoryNested<A> editOrNewRepository() {
    return withNewRepositoryLike(getRepository() != null ? getRepository(): new io.fabric8.openshift.api.model.RepositoryImportSpecBuilder().build());
  }
  public io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.RepositoryNested<A> editOrNewRepositoryLike(io.fabric8.openshift.api.model.RepositoryImportSpec item) {
    return withNewRepositoryLike(getRepository() != null ? getRepository(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImageStreamImportSpecFluentImpl that = (ImageStreamImportSpecFluentImpl) o;
    if (images != null ? !images.equals(that.images) :that.images != null) return false;
    if (_import != null ? !_import.equals(that._import) :that._import != null) return false;
    if (repository != null ? !repository.equals(that.repository) :that.repository != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(images,  _import,  repository,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (images != null && !images.isEmpty()) { sb.append("images:"); sb.append(images + ","); }
    if (_import != null) { sb.append("_import:"); sb.append(_import + ","); }
    if (repository != null) { sb.append("repository:"); sb.append(repository + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withImport() {
    return withImport(true);
  }
  class ImagesNestedImpl<N> extends ImageImportSpecFluentImpl<ImageStreamImportSpecFluent.ImagesNested<N>> implements io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.ImagesNested<N>,Nested<N>{
    ImagesNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.ImageImportSpec item) {
      this.index = index;
      this.builder = new ImageImportSpecBuilder(this, item);
    }
    ImagesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ImageImportSpecBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageImportSpecBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ImageStreamImportSpecFluentImpl.this.setToImages(index,builder.build());
    }
    public N endImage() {
      return and();
    }
    
  }
  class RepositoryNestedImpl<N> extends RepositoryImportSpecFluentImpl<ImageStreamImportSpecFluent.RepositoryNested<N>> implements io.fabric8.openshift.api.model.ImageStreamImportSpecFluent.RepositoryNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RepositoryNestedImpl(io.fabric8.openshift.api.model.RepositoryImportSpec item) {
      this.builder = new RepositoryImportSpecBuilder(this, item);
    }
    RepositoryNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.RepositoryImportSpecBuilder(this);
    }
    io.fabric8.openshift.api.model.RepositoryImportSpecBuilder builder;
    public N and() {
      return (N) ImageStreamImportSpecFluentImpl.this.withRepository(builder.build());
    }
    public N endRepository() {
      return and();
    }
    
  }
  
}