package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamSpecBuilder extends ImageStreamSpecFluentImpl<ImageStreamSpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ImageStreamSpec,ImageStreamSpecBuilder>{
  public ImageStreamSpecBuilder() {
    this(false);
  }
  public ImageStreamSpecBuilder(Boolean validationEnabled) {
    this(new ImageStreamSpec(), validationEnabled);
  }
  public ImageStreamSpecBuilder(io.fabric8.openshift.api.model.ImageStreamSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamSpecBuilder(io.fabric8.openshift.api.model.ImageStreamSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageStreamSpec(), validationEnabled);
  }
  public ImageStreamSpecBuilder(io.fabric8.openshift.api.model.ImageStreamSpecFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamSpec instance) {
    this(fluent, instance, false);
  }
  public ImageStreamSpecBuilder(io.fabric8.openshift.api.model.ImageStreamSpecFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDockerImageRepository(instance.getDockerImageRepository()); 
    fluent.withLookupPolicy(instance.getLookupPolicy()); 
    fluent.withTags(instance.getTags()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamSpecBuilder(io.fabric8.openshift.api.model.ImageStreamSpec instance) {
    this(instance,false);
  }
  public ImageStreamSpecBuilder(io.fabric8.openshift.api.model.ImageStreamSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDockerImageRepository(instance.getDockerImageRepository()); 
    this.withLookupPolicy(instance.getLookupPolicy()); 
    this.withTags(instance.getTags()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageStreamSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageStreamSpec build() {
    ImageStreamSpec buildable = new ImageStreamSpec(fluent.getDockerImageRepository(),fluent.getLookupPolicy(),fluent.getTags());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}