package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamTagBuilder extends ImageStreamTagFluentImpl<ImageStreamTagBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ImageStreamTag,ImageStreamTagBuilder>{
  public ImageStreamTagBuilder() {
    this(false);
  }
  public ImageStreamTagBuilder(Boolean validationEnabled) {
    this(new ImageStreamTag(), validationEnabled);
  }
  public ImageStreamTagBuilder(ImageStreamTagFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamTagBuilder(io.fabric8.openshift.api.model.ImageStreamTagFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageStreamTag(), validationEnabled);
  }
  public ImageStreamTagBuilder(io.fabric8.openshift.api.model.ImageStreamTagFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamTag instance) {
    this(fluent, instance, false);
  }
  public ImageStreamTagBuilder(io.fabric8.openshift.api.model.ImageStreamTagFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamTag instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withGeneration(instance.getGeneration()); 
    fluent.withImage(instance.getImage()); 
    fluent.withKind(instance.getKind()); 
    fluent.withLookupPolicy(instance.getLookupPolicy()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withTag(instance.getTag()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamTagBuilder(io.fabric8.openshift.api.model.ImageStreamTag instance) {
    this(instance,false);
  }
  public ImageStreamTagBuilder(io.fabric8.openshift.api.model.ImageStreamTag instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withConditions(instance.getConditions()); 
    this.withGeneration(instance.getGeneration()); 
    this.withImage(instance.getImage()); 
    this.withKind(instance.getKind()); 
    this.withLookupPolicy(instance.getLookupPolicy()); 
    this.withMetadata(instance.getMetadata()); 
    this.withTag(instance.getTag()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageStreamTagFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageStreamTag build() {
    ImageStreamTag buildable = new ImageStreamTag(fluent.getApiVersion(),fluent.getConditions(),fluent.getGeneration(),fluent.getImage(),fluent.getKind(),fluent.getLookupPolicy(),fluent.getMetadata(),fluent.getTag());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}