package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageStreamTagFluentImpl<A extends ImageStreamTagFluent<A>> extends BaseFluent<A> implements ImageStreamTagFluent<A>{
  public ImageStreamTagFluentImpl() {
  }
  public ImageStreamTagFluentImpl(io.fabric8.openshift.api.model.ImageStreamTag instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withConditions(instance.getConditions()); 
    this.withGeneration(instance.getGeneration()); 
    this.withImage(instance.getImage()); 
    this.withKind(instance.getKind()); 
    this.withLookupPolicy(instance.getLookupPolicy()); 
    this.withMetadata(instance.getMetadata()); 
    this.withTag(instance.getTag()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private ArrayList<TagEventConditionBuilder> conditions = new java.util.ArrayList<TagEventConditionBuilder>();
  private Long generation;
  private ImageBuilder image;
  private java.lang.String kind;
  private ImageLookupPolicyBuilder lookupPolicy;
  private ObjectMetaBuilder metadata;
  private TagReferenceBuilder tag;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToConditions(Integer index,io.fabric8.openshift.api.model.TagEventCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.TagEventConditionBuilder>();}
    io.fabric8.openshift.api.model.TagEventConditionBuilder builder = new io.fabric8.openshift.api.model.TagEventConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.openshift.api.model.TagEventCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.TagEventConditionBuilder>();}
    io.fabric8.openshift.api.model.TagEventConditionBuilder builder = new io.fabric8.openshift.api.model.TagEventConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.TagEventCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.TagEventConditionBuilder>();}
    for (io.fabric8.openshift.api.model.TagEventCondition item : items) {io.fabric8.openshift.api.model.TagEventConditionBuilder builder = new io.fabric8.openshift.api.model.TagEventConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<io.fabric8.openshift.api.model.TagEventCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.TagEventConditionBuilder>();}
    for (io.fabric8.openshift.api.model.TagEventCondition item : items) {io.fabric8.openshift.api.model.TagEventConditionBuilder builder = new io.fabric8.openshift.api.model.TagEventConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.TagEventCondition... items) {
    for (io.fabric8.openshift.api.model.TagEventCondition item : items) {io.fabric8.openshift.api.model.TagEventConditionBuilder builder = new io.fabric8.openshift.api.model.TagEventConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.openshift.api.model.TagEventCondition> items) {
    for (io.fabric8.openshift.api.model.TagEventCondition item : items) {io.fabric8.openshift.api.model.TagEventConditionBuilder builder = new io.fabric8.openshift.api.model.TagEventConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<io.fabric8.openshift.api.model.TagEventConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.TagEventConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.TagEventConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.openshift.api.model.TagEventCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.TagEventCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public io.fabric8.openshift.api.model.TagEventCondition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.openshift.api.model.TagEventCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.openshift.api.model.TagEventCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.TagEventCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.TagEventConditionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.TagEventConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.TagEventConditionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.TagEventConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.openshift.api.model.TagEventCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.TagEventCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.TagEventCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.openshift.api.model.TagEventCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public ImageStreamTagFluent.ConditionsNested<A> addNewCondition() {
    return new ImageStreamTagFluentImpl.ConditionsNestedImpl();
  }
  public ImageStreamTagFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.openshift.api.model.TagEventCondition item) {
    return new ImageStreamTagFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.openshift.api.model.TagEventCondition item) {
    return new io.fabric8.openshift.api.model.ImageStreamTagFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.TagEventConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public java.lang.Long getGeneration() {
    return this.generation;
  }
  public A withGeneration(java.lang.Long generation) {
    this.generation=generation; return (A) this;
  }
  public java.lang.Boolean hasGeneration() {
    return this.generation != null;
  }
  
  /**
   * This method has been deprecated, please use method buildImage instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.Image getImage() {
    return this.image!=null ?this.image.build():null;
  }
  public io.fabric8.openshift.api.model.Image buildImage() {
    return this.image!=null ?this.image.build():null;
  }
  public A withImage(io.fabric8.openshift.api.model.Image image) {
    _visitables.get("image").remove(this.image);
    if (image!=null){ this.image= new io.fabric8.openshift.api.model.ImageBuilder(image); _visitables.get("image").add(this.image);} return (A) this;
  }
  public java.lang.Boolean hasImage() {
    return this.image != null;
  }
  public ImageStreamTagFluent.ImageNested<A> withNewImage() {
    return new ImageStreamTagFluentImpl.ImageNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.ImageNested<A> withNewImageLike(io.fabric8.openshift.api.model.Image item) {
    return new io.fabric8.openshift.api.model.ImageStreamTagFluentImpl.ImageNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.ImageNested<A> editImage() {
    return withNewImageLike(getImage());
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.ImageNested<A> editOrNewImage() {
    return withNewImageLike(getImage() != null ? getImage(): new io.fabric8.openshift.api.model.ImageBuilder().build());
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.ImageNested<A> editOrNewImageLike(io.fabric8.openshift.api.model.Image item) {
    return withNewImageLike(getImage() != null ? getImage(): item);
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildLookupPolicy instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.ImageLookupPolicy getLookupPolicy() {
    return this.lookupPolicy!=null ?this.lookupPolicy.build():null;
  }
  public io.fabric8.openshift.api.model.ImageLookupPolicy buildLookupPolicy() {
    return this.lookupPolicy!=null ?this.lookupPolicy.build():null;
  }
  public A withLookupPolicy(io.fabric8.openshift.api.model.ImageLookupPolicy lookupPolicy) {
    _visitables.get("lookupPolicy").remove(this.lookupPolicy);
    if (lookupPolicy!=null){ this.lookupPolicy= new ImageLookupPolicyBuilder(lookupPolicy); _visitables.get("lookupPolicy").add(this.lookupPolicy);} return (A) this;
  }
  public java.lang.Boolean hasLookupPolicy() {
    return this.lookupPolicy != null;
  }
  public A withNewLookupPolicy(java.lang.Boolean local) {
    return (A)withLookupPolicy(new ImageLookupPolicy(local));
  }
  public ImageStreamTagFluent.LookupPolicyNested<A> withNewLookupPolicy() {
    return new ImageStreamTagFluentImpl.LookupPolicyNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.LookupPolicyNested<A> withNewLookupPolicyLike(io.fabric8.openshift.api.model.ImageLookupPolicy item) {
    return new io.fabric8.openshift.api.model.ImageStreamTagFluentImpl.LookupPolicyNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.LookupPolicyNested<A> editLookupPolicy() {
    return withNewLookupPolicyLike(getLookupPolicy());
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.LookupPolicyNested<A> editOrNewLookupPolicy() {
    return withNewLookupPolicyLike(getLookupPolicy() != null ? getLookupPolicy(): new io.fabric8.openshift.api.model.ImageLookupPolicyBuilder().build());
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.LookupPolicyNested<A> editOrNewLookupPolicyLike(io.fabric8.openshift.api.model.ImageLookupPolicy item) {
    return withNewLookupPolicyLike(getLookupPolicy() != null ? getLookupPolicy(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ImageStreamTagFluent.MetadataNested<A> withNewMetadata() {
    return new ImageStreamTagFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new io.fabric8.openshift.api.model.ImageStreamTagFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTag instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public TagReference getTag() {
    return this.tag!=null ?this.tag.build():null;
  }
  public io.fabric8.openshift.api.model.TagReference buildTag() {
    return this.tag!=null ?this.tag.build():null;
  }
  public A withTag(io.fabric8.openshift.api.model.TagReference tag) {
    _visitables.get("tag").remove(this.tag);
    if (tag!=null){ this.tag= new io.fabric8.openshift.api.model.TagReferenceBuilder(tag); _visitables.get("tag").add(this.tag);} return (A) this;
  }
  public java.lang.Boolean hasTag() {
    return this.tag != null;
  }
  public ImageStreamTagFluent.TagNested<A> withNewTag() {
    return new ImageStreamTagFluentImpl.TagNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.TagNested<A> withNewTagLike(io.fabric8.openshift.api.model.TagReference item) {
    return new io.fabric8.openshift.api.model.ImageStreamTagFluentImpl.TagNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.TagNested<A> editTag() {
    return withNewTagLike(getTag());
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.TagNested<A> editOrNewTag() {
    return withNewTagLike(getTag() != null ? getTag(): new io.fabric8.openshift.api.model.TagReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.ImageStreamTagFluent.TagNested<A> editOrNewTagLike(io.fabric8.openshift.api.model.TagReference item) {
    return withNewTagLike(getTag() != null ? getTag(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImageStreamTagFluentImpl that = (ImageStreamTagFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (generation != null ? !generation.equals(that.generation) :that.generation != null) return false;
    if (image != null ? !image.equals(that.image) :that.image != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (lookupPolicy != null ? !lookupPolicy.equals(that.lookupPolicy) :that.lookupPolicy != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (tag != null ? !tag.equals(that.tag) :that.tag != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  conditions,  generation,  image,  kind,  lookupPolicy,  metadata,  tag,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (generation != null) { sb.append("generation:"); sb.append(generation + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (lookupPolicy != null) { sb.append("lookupPolicy:"); sb.append(lookupPolicy + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (tag != null) { sb.append("tag:"); sb.append(tag + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends TagEventConditionFluentImpl<ImageStreamTagFluent.ConditionsNested<N>> implements io.fabric8.openshift.api.model.ImageStreamTagFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.TagEventCondition item) {
      this.index = index;
      this.builder = new TagEventConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.TagEventConditionBuilder(this);
    }
    io.fabric8.openshift.api.model.TagEventConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ImageStreamTagFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class ImageNestedImpl<N> extends ImageFluentImpl<ImageStreamTagFluent.ImageNested<N>> implements ImageStreamTagFluent.ImageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageNestedImpl(io.fabric8.openshift.api.model.Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageBuilder builder;
    public N and() {
      return (N) ImageStreamTagFluentImpl.this.withImage(builder.build());
    }
    public N endImage() {
      return and();
    }
    
  }
  class LookupPolicyNestedImpl<N> extends ImageLookupPolicyFluentImpl<ImageStreamTagFluent.LookupPolicyNested<N>> implements io.fabric8.openshift.api.model.ImageStreamTagFluent.LookupPolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    LookupPolicyNestedImpl(ImageLookupPolicy item) {
      this.builder = new ImageLookupPolicyBuilder(this, item);
    }
    LookupPolicyNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageLookupPolicyBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageLookupPolicyBuilder builder;
    public N and() {
      return (N) ImageStreamTagFluentImpl.this.withLookupPolicy(builder.build());
    }
    public N endLookupPolicy() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ImageStreamTagFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.ImageStreamTagFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) ImageStreamTagFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class TagNestedImpl<N> extends TagReferenceFluentImpl<ImageStreamTagFluent.TagNested<N>> implements io.fabric8.openshift.api.model.ImageStreamTagFluent.TagNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TagNestedImpl(TagReference item) {
      this.builder = new TagReferenceBuilder(this, item);
    }
    TagNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.TagReferenceBuilder(this);
    }
    io.fabric8.openshift.api.model.TagReferenceBuilder builder;
    public N and() {
      return (N) ImageStreamTagFluentImpl.this.withTag(builder.build());
    }
    public N endTag() {
      return and();
    }
    
  }
  
}