package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamTagListBuilder extends ImageStreamTagListFluentImpl<ImageStreamTagListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ImageStreamTagList,ImageStreamTagListBuilder>{
  public ImageStreamTagListBuilder() {
    this(false);
  }
  public ImageStreamTagListBuilder(Boolean validationEnabled) {
    this(new ImageStreamTagList(), validationEnabled);
  }
  public ImageStreamTagListBuilder(ImageStreamTagListFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamTagListBuilder(io.fabric8.openshift.api.model.ImageStreamTagListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageStreamTagList(), validationEnabled);
  }
  public ImageStreamTagListBuilder(io.fabric8.openshift.api.model.ImageStreamTagListFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamTagList instance) {
    this(fluent, instance, false);
  }
  public ImageStreamTagListBuilder(io.fabric8.openshift.api.model.ImageStreamTagListFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamTagList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamTagListBuilder(io.fabric8.openshift.api.model.ImageStreamTagList instance) {
    this(instance,false);
  }
  public ImageStreamTagListBuilder(io.fabric8.openshift.api.model.ImageStreamTagList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageStreamTagListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageStreamTagList build() {
    ImageStreamTagList buildable = new ImageStreamTagList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}