package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamTagReferenceBuilder extends ImageStreamTagReferenceFluentImpl<ImageStreamTagReferenceBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ImageStreamTagReference,ImageStreamTagReferenceBuilder>{
  public ImageStreamTagReferenceBuilder() {
    this(false);
  }
  public ImageStreamTagReferenceBuilder(Boolean validationEnabled) {
    this(new ImageStreamTagReference(), validationEnabled);
  }
  public ImageStreamTagReferenceBuilder(io.fabric8.openshift.api.model.ImageStreamTagReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamTagReferenceBuilder(io.fabric8.openshift.api.model.ImageStreamTagReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageStreamTagReference(), validationEnabled);
  }
  public ImageStreamTagReferenceBuilder(io.fabric8.openshift.api.model.ImageStreamTagReferenceFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamTagReference instance) {
    this(fluent, instance, false);
  }
  public ImageStreamTagReferenceBuilder(io.fabric8.openshift.api.model.ImageStreamTagReferenceFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamTagReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamTagReferenceBuilder(io.fabric8.openshift.api.model.ImageStreamTagReference instance) {
    this(instance,false);
  }
  public ImageStreamTagReferenceBuilder(io.fabric8.openshift.api.model.ImageStreamTagReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageStreamTagReferenceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageStreamTagReference build() {
    ImageStreamTagReference buildable = new ImageStreamTagReference(fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}