package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class InfrastructureListFluentImpl<A extends InfrastructureListFluent<A>> extends BaseFluent<A> implements InfrastructureListFluent<A>{
  public InfrastructureListFluentImpl() {
  }
  public InfrastructureListFluentImpl(InfrastructureList instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private ArrayList<InfrastructureBuilder> items = new java.util.ArrayList<io.fabric8.openshift.api.model.InfrastructureBuilder>();
  private java.lang.String kind;
  private ListMeta metadata;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToItems(Integer index,io.fabric8.openshift.api.model.Infrastructure item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.openshift.api.model.InfrastructureBuilder>();}
    io.fabric8.openshift.api.model.InfrastructureBuilder builder = new io.fabric8.openshift.api.model.InfrastructureBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
  }
  public A setToItems(java.lang.Integer index,io.fabric8.openshift.api.model.Infrastructure item) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.openshift.api.model.InfrastructureBuilder>();}
    io.fabric8.openshift.api.model.InfrastructureBuilder builder = new io.fabric8.openshift.api.model.InfrastructureBuilder(item);
    if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
    if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
     return (A)this;
  }
  public A addToItems(io.fabric8.openshift.api.model.Infrastructure... items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.openshift.api.model.InfrastructureBuilder>();}
    for (io.fabric8.openshift.api.model.Infrastructure item : items) {io.fabric8.openshift.api.model.InfrastructureBuilder builder = new io.fabric8.openshift.api.model.InfrastructureBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToItems(Collection<io.fabric8.openshift.api.model.Infrastructure> items) {
    if (this.items == null) {this.items = new java.util.ArrayList<io.fabric8.openshift.api.model.InfrastructureBuilder>();}
    for (io.fabric8.openshift.api.model.Infrastructure item : items) {io.fabric8.openshift.api.model.InfrastructureBuilder builder = new io.fabric8.openshift.api.model.InfrastructureBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromItems(io.fabric8.openshift.api.model.Infrastructure... items) {
    for (io.fabric8.openshift.api.model.Infrastructure item : items) {io.fabric8.openshift.api.model.InfrastructureBuilder builder = new io.fabric8.openshift.api.model.InfrastructureBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromItems(java.util.Collection<io.fabric8.openshift.api.model.Infrastructure> items) {
    for (io.fabric8.openshift.api.model.Infrastructure item : items) {io.fabric8.openshift.api.model.InfrastructureBuilder builder = new io.fabric8.openshift.api.model.InfrastructureBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromItems(Predicate<io.fabric8.openshift.api.model.InfrastructureBuilder> predicate) {
    if (items == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.InfrastructureBuilder> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.InfrastructureBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.openshift.api.model.Infrastructure> getItems() {
    return items != null ? build(items) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.Infrastructure> buildItems() {
    return items != null ? build(items) : null;
  }
  public io.fabric8.openshift.api.model.Infrastructure buildItem(java.lang.Integer index) {
    return this.items.get(index).build();
  }
  public io.fabric8.openshift.api.model.Infrastructure buildFirstItem() {
    return this.items.get(0).build();
  }
  public io.fabric8.openshift.api.model.Infrastructure buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.Infrastructure buildMatchingItem(java.util.function.Predicate<io.fabric8.openshift.api.model.InfrastructureBuilder> predicate) {
    for (io.fabric8.openshift.api.model.InfrastructureBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingItem(java.util.function.Predicate<io.fabric8.openshift.api.model.InfrastructureBuilder> predicate) {
    for (io.fabric8.openshift.api.model.InfrastructureBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withItems(java.util.List<io.fabric8.openshift.api.model.Infrastructure> items) {
    if (this.items != null) { _visitables.get("items").removeAll(this.items);}
    if (items != null) {this.items = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.Infrastructure item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  public A withItems(io.fabric8.openshift.api.model.Infrastructure... items) {
    if (this.items != null) {this.items.clear();}
    if (items != null) {for (io.fabric8.openshift.api.model.Infrastructure item :items){ this.addToItems(item);}} return (A) this;
  }
  public java.lang.Boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  public InfrastructureListFluent.ItemsNested<A> addNewItem() {
    return new InfrastructureListFluentImpl.ItemsNestedImpl();
  }
  public io.fabric8.openshift.api.model.InfrastructureListFluent.ItemsNested<A> addNewItemLike(io.fabric8.openshift.api.model.Infrastructure item) {
    return new InfrastructureListFluentImpl.ItemsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.InfrastructureListFluent.ItemsNested<A> setNewItemLike(java.lang.Integer index,io.fabric8.openshift.api.model.Infrastructure item) {
    return new io.fabric8.openshift.api.model.InfrastructureListFluentImpl.ItemsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.InfrastructureListFluent.ItemsNested<A> editItem(java.lang.Integer index) {
    if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
    return setNewItemLike(index, buildItem(index));
  }
  public io.fabric8.openshift.api.model.InfrastructureListFluent.ItemsNested<A> editFirstItem() {
    if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
    return setNewItemLike(0, buildItem(0));
  }
  public io.fabric8.openshift.api.model.InfrastructureListFluent.ItemsNested<A> editLastItem() {
    int index = items.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
    return setNewItemLike(index, buildItem(index));
  }
  public io.fabric8.openshift.api.model.InfrastructureListFluent.ItemsNested<A> editMatchingItem(java.util.function.Predicate<io.fabric8.openshift.api.model.InfrastructureBuilder> predicate) {
    int index = -1;
    for (int i=0;i<items.size();i++) { 
    if (predicate.test(items.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
    return setNewItemLike(index, buildItem(index));
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  public io.fabric8.kubernetes.api.model.ListMeta getMetadata() {
    return this.metadata;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ListMeta metadata) {
    this.metadata=metadata; return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public A withNewMetadata(java.lang.String _continue,Long remainingItemCount,java.lang.String resourceVersion,java.lang.String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    InfrastructureListFluentImpl that = (InfrastructureListFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (items != null ? !items.equals(that.items) :that.items != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (items != null && !items.isEmpty()) { sb.append("items:"); sb.append(items + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ItemsNestedImpl<N> extends InfrastructureFluentImpl<InfrastructureListFluent.ItemsNested<N>> implements InfrastructureListFluent.ItemsNested<N>,Nested<N>{
    ItemsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.Infrastructure item) {
      this.index = index;
      this.builder = new InfrastructureBuilder(this, item);
    }
    ItemsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.InfrastructureBuilder(this);
    }
    io.fabric8.openshift.api.model.InfrastructureBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) InfrastructureListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endItem() {
      return and();
    }
    
  }
  
}