package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class InfrastructureSpecFluentImpl<A extends InfrastructureSpecFluent<A>> extends BaseFluent<A> implements InfrastructureSpecFluent<A>{
  public InfrastructureSpecFluentImpl() {
  }
  public InfrastructureSpecFluentImpl(io.fabric8.openshift.api.model.InfrastructureSpec instance) {
    this.withCloudConfig(instance.getCloudConfig()); 
    this.withPlatformSpec(instance.getPlatformSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ConfigMapFileReferenceBuilder cloudConfig;
  private PlatformSpecBuilder platformSpec;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCloudConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMapFileReference getCloudConfig() {
    return this.cloudConfig!=null ?this.cloudConfig.build():null;
  }
  public io.fabric8.openshift.api.model.ConfigMapFileReference buildCloudConfig() {
    return this.cloudConfig!=null ?this.cloudConfig.build():null;
  }
  public A withCloudConfig(io.fabric8.openshift.api.model.ConfigMapFileReference cloudConfig) {
    _visitables.get("cloudConfig").remove(this.cloudConfig);
    if (cloudConfig!=null){ this.cloudConfig= new io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder(cloudConfig); _visitables.get("cloudConfig").add(this.cloudConfig);} return (A) this;
  }
  public Boolean hasCloudConfig() {
    return this.cloudConfig != null;
  }
  public A withNewCloudConfig(java.lang.String key,java.lang.String name) {
    return (A)withCloudConfig(new ConfigMapFileReference(key, name));
  }
  public InfrastructureSpecFluent.CloudConfigNested<A> withNewCloudConfig() {
    return new InfrastructureSpecFluentImpl.CloudConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.InfrastructureSpecFluent.CloudConfigNested<A> withNewCloudConfigLike(io.fabric8.openshift.api.model.ConfigMapFileReference item) {
    return new InfrastructureSpecFluentImpl.CloudConfigNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.InfrastructureSpecFluent.CloudConfigNested<A> editCloudConfig() {
    return withNewCloudConfigLike(getCloudConfig());
  }
  public io.fabric8.openshift.api.model.InfrastructureSpecFluent.CloudConfigNested<A> editOrNewCloudConfig() {
    return withNewCloudConfigLike(getCloudConfig() != null ? getCloudConfig(): new io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.InfrastructureSpecFluent.CloudConfigNested<A> editOrNewCloudConfigLike(io.fabric8.openshift.api.model.ConfigMapFileReference item) {
    return withNewCloudConfigLike(getCloudConfig() != null ? getCloudConfig(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPlatformSpec instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public PlatformSpec getPlatformSpec() {
    return this.platformSpec!=null ?this.platformSpec.build():null;
  }
  public io.fabric8.openshift.api.model.PlatformSpec buildPlatformSpec() {
    return this.platformSpec!=null ?this.platformSpec.build():null;
  }
  public A withPlatformSpec(io.fabric8.openshift.api.model.PlatformSpec platformSpec) {
    _visitables.get("platformSpec").remove(this.platformSpec);
    if (platformSpec!=null){ this.platformSpec= new io.fabric8.openshift.api.model.PlatformSpecBuilder(platformSpec); _visitables.get("platformSpec").add(this.platformSpec);} return (A) this;
  }
  public java.lang.Boolean hasPlatformSpec() {
    return this.platformSpec != null;
  }
  public InfrastructureSpecFluent.PlatformSpecNested<A> withNewPlatformSpec() {
    return new InfrastructureSpecFluentImpl.PlatformSpecNestedImpl();
  }
  public io.fabric8.openshift.api.model.InfrastructureSpecFluent.PlatformSpecNested<A> withNewPlatformSpecLike(io.fabric8.openshift.api.model.PlatformSpec item) {
    return new io.fabric8.openshift.api.model.InfrastructureSpecFluentImpl.PlatformSpecNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.InfrastructureSpecFluent.PlatformSpecNested<A> editPlatformSpec() {
    return withNewPlatformSpecLike(getPlatformSpec());
  }
  public io.fabric8.openshift.api.model.InfrastructureSpecFluent.PlatformSpecNested<A> editOrNewPlatformSpec() {
    return withNewPlatformSpecLike(getPlatformSpec() != null ? getPlatformSpec(): new io.fabric8.openshift.api.model.PlatformSpecBuilder().build());
  }
  public io.fabric8.openshift.api.model.InfrastructureSpecFluent.PlatformSpecNested<A> editOrNewPlatformSpecLike(io.fabric8.openshift.api.model.PlatformSpec item) {
    return withNewPlatformSpecLike(getPlatformSpec() != null ? getPlatformSpec(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    InfrastructureSpecFluentImpl that = (InfrastructureSpecFluentImpl) o;
    if (cloudConfig != null ? !cloudConfig.equals(that.cloudConfig) :that.cloudConfig != null) return false;
    if (platformSpec != null ? !platformSpec.equals(that.platformSpec) :that.platformSpec != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(cloudConfig,  platformSpec,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cloudConfig != null) { sb.append("cloudConfig:"); sb.append(cloudConfig + ","); }
    if (platformSpec != null) { sb.append("platformSpec:"); sb.append(platformSpec + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CloudConfigNestedImpl<N> extends ConfigMapFileReferenceFluentImpl<InfrastructureSpecFluent.CloudConfigNested<N>> implements io.fabric8.openshift.api.model.InfrastructureSpecFluent.CloudConfigNested<N>,Nested<N>{
    CloudConfigNestedImpl(io.fabric8.openshift.api.model.ConfigMapFileReference item) {
      this.builder = new ConfigMapFileReferenceBuilder(this, item);
    }
    CloudConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder(this);
    }
    io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder builder;
    public N and() {
      return (N) InfrastructureSpecFluentImpl.this.withCloudConfig(builder.build());
    }
    public N endCloudConfig() {
      return and();
    }
    
  }
  class PlatformSpecNestedImpl<N> extends PlatformSpecFluentImpl<InfrastructureSpecFluent.PlatformSpecNested<N>> implements io.fabric8.openshift.api.model.InfrastructureSpecFluent.PlatformSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PlatformSpecNestedImpl(PlatformSpec item) {
      this.builder = new PlatformSpecBuilder(this, item);
    }
    PlatformSpecNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.PlatformSpecBuilder(this);
    }
    io.fabric8.openshift.api.model.PlatformSpecBuilder builder;
    public N and() {
      return (N) InfrastructureSpecFluentImpl.this.withPlatformSpec(builder.build());
    }
    public N endPlatformSpec() {
      return and();
    }
    
  }
  
}