package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InfrastructureStatusBuilder extends InfrastructureStatusFluentImpl<InfrastructureStatusBuilder> implements VisitableBuilder<InfrastructureStatus,io.fabric8.openshift.api.model.InfrastructureStatusBuilder>{
  public InfrastructureStatusBuilder() {
    this(false);
  }
  public InfrastructureStatusBuilder(Boolean validationEnabled) {
    this(new InfrastructureStatus(), validationEnabled);
  }
  public InfrastructureStatusBuilder(InfrastructureStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public InfrastructureStatusBuilder(io.fabric8.openshift.api.model.InfrastructureStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new InfrastructureStatus(), validationEnabled);
  }
  public InfrastructureStatusBuilder(io.fabric8.openshift.api.model.InfrastructureStatusFluent<?> fluent,io.fabric8.openshift.api.model.InfrastructureStatus instance) {
    this(fluent, instance, false);
  }
  public InfrastructureStatusBuilder(io.fabric8.openshift.api.model.InfrastructureStatusFluent<?> fluent,io.fabric8.openshift.api.model.InfrastructureStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiServerInternalURI(instance.getApiServerInternalURI()); 
    fluent.withApiServerURL(instance.getApiServerURL()); 
    fluent.withControlPlaneTopology(instance.getControlPlaneTopology()); 
    fluent.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain()); 
    fluent.withInfrastructureName(instance.getInfrastructureName()); 
    fluent.withInfrastructureTopology(instance.getInfrastructureTopology()); 
    fluent.withPlatform(instance.getPlatform()); 
    fluent.withPlatformStatus(instance.getPlatformStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public InfrastructureStatusBuilder(io.fabric8.openshift.api.model.InfrastructureStatus instance) {
    this(instance,false);
  }
  public InfrastructureStatusBuilder(io.fabric8.openshift.api.model.InfrastructureStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiServerInternalURI(instance.getApiServerInternalURI()); 
    this.withApiServerURL(instance.getApiServerURL()); 
    this.withControlPlaneTopology(instance.getControlPlaneTopology()); 
    this.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain()); 
    this.withInfrastructureName(instance.getInfrastructureName()); 
    this.withInfrastructureTopology(instance.getInfrastructureTopology()); 
    this.withPlatform(instance.getPlatform()); 
    this.withPlatformStatus(instance.getPlatformStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.InfrastructureStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.InfrastructureStatus build() {
    InfrastructureStatus buildable = new InfrastructureStatus(fluent.getApiServerInternalURI(),fluent.getApiServerURL(),fluent.getControlPlaneTopology(),fluent.getEtcdDiscoveryDomain(),fluent.getInfrastructureName(),fluent.getInfrastructureTopology(),fluent.getPlatform(),fluent.getPlatformStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}