package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressSpecBuilder extends IngressSpecFluentImpl<IngressSpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.IngressSpec,io.fabric8.openshift.api.model.IngressSpecBuilder>{
  public IngressSpecBuilder() {
    this(false);
  }
  public IngressSpecBuilder(Boolean validationEnabled) {
    this(new IngressSpec(), validationEnabled);
  }
  public IngressSpecBuilder(IngressSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressSpecBuilder(io.fabric8.openshift.api.model.IngressSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IngressSpec(), validationEnabled);
  }
  public IngressSpecBuilder(io.fabric8.openshift.api.model.IngressSpecFluent<?> fluent,io.fabric8.openshift.api.model.IngressSpec instance) {
    this(fluent, instance, false);
  }
  public IngressSpecBuilder(io.fabric8.openshift.api.model.IngressSpecFluent<?> fluent,io.fabric8.openshift.api.model.IngressSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAppsDomain(instance.getAppsDomain()); 
    fluent.withComponentRoutes(instance.getComponentRoutes()); 
    fluent.withDomain(instance.getDomain()); 
    fluent.withRequiredHSTSPolicies(instance.getRequiredHSTSPolicies()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressSpecBuilder(io.fabric8.openshift.api.model.IngressSpec instance) {
    this(instance,false);
  }
  public IngressSpecBuilder(io.fabric8.openshift.api.model.IngressSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAppsDomain(instance.getAppsDomain()); 
    this.withComponentRoutes(instance.getComponentRoutes()); 
    this.withDomain(instance.getDomain()); 
    this.withRequiredHSTSPolicies(instance.getRequiredHSTSPolicies()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.IngressSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.IngressSpec build() {
    IngressSpec buildable = new IngressSpec(fluent.getAppsDomain(),fluent.getComponentRoutes(),fluent.getDomain(),fluent.getRequiredHSTSPolicies());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}