package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressStatusBuilder extends IngressStatusFluentImpl<IngressStatusBuilder> implements VisitableBuilder<IngressStatus,io.fabric8.openshift.api.model.IngressStatusBuilder>{
  public IngressStatusBuilder() {
    this(false);
  }
  public IngressStatusBuilder(Boolean validationEnabled) {
    this(new IngressStatus(), validationEnabled);
  }
  public IngressStatusBuilder(io.fabric8.openshift.api.model.IngressStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressStatusBuilder(io.fabric8.openshift.api.model.IngressStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IngressStatus(), validationEnabled);
  }
  public IngressStatusBuilder(io.fabric8.openshift.api.model.IngressStatusFluent<?> fluent,io.fabric8.openshift.api.model.IngressStatus instance) {
    this(fluent, instance, false);
  }
  public IngressStatusBuilder(io.fabric8.openshift.api.model.IngressStatusFluent<?> fluent,io.fabric8.openshift.api.model.IngressStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withComponentRoutes(instance.getComponentRoutes()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressStatusBuilder(io.fabric8.openshift.api.model.IngressStatus instance) {
    this(instance,false);
  }
  public IngressStatusBuilder(io.fabric8.openshift.api.model.IngressStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withComponentRoutes(instance.getComponentRoutes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.IngressStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.IngressStatus build() {
    IngressStatus buildable = new IngressStatus(fluent.getComponentRoutes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}