package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LocalResourceAccessReviewBuilder extends LocalResourceAccessReviewFluentImpl<LocalResourceAccessReviewBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.LocalResourceAccessReview,io.fabric8.openshift.api.model.LocalResourceAccessReviewBuilder>{
  public LocalResourceAccessReviewBuilder() {
    this(false);
  }
  public LocalResourceAccessReviewBuilder(Boolean validationEnabled) {
    this(new LocalResourceAccessReview(), validationEnabled);
  }
  public LocalResourceAccessReviewBuilder(LocalResourceAccessReviewFluent<?> fluent) {
    this(fluent, false);
  }
  public LocalResourceAccessReviewBuilder(io.fabric8.openshift.api.model.LocalResourceAccessReviewFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new LocalResourceAccessReview(), validationEnabled);
  }
  public LocalResourceAccessReviewBuilder(io.fabric8.openshift.api.model.LocalResourceAccessReviewFluent<?> fluent,io.fabric8.openshift.api.model.LocalResourceAccessReview instance) {
    this(fluent, instance, false);
  }
  public LocalResourceAccessReviewBuilder(io.fabric8.openshift.api.model.LocalResourceAccessReviewFluent<?> fluent,io.fabric8.openshift.api.model.LocalResourceAccessReview instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withContent(instance.getContent()); 
    fluent.withIsNonResourceURL(instance.getIsNonResourceURL()); 
    fluent.withKind(instance.getKind()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withPath(instance.getPath()); 
    fluent.withResource(instance.getResource()); 
    fluent.withResourceAPIGroup(instance.getResourceAPIGroup()); 
    fluent.withResourceAPIVersion(instance.getResourceAPIVersion()); 
    fluent.withResourceName(instance.getResourceName()); 
    fluent.withVerb(instance.getVerb()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LocalResourceAccessReviewBuilder(io.fabric8.openshift.api.model.LocalResourceAccessReview instance) {
    this(instance,false);
  }
  public LocalResourceAccessReviewBuilder(io.fabric8.openshift.api.model.LocalResourceAccessReview instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withContent(instance.getContent()); 
    this.withIsNonResourceURL(instance.getIsNonResourceURL()); 
    this.withKind(instance.getKind()); 
    this.withNamespace(instance.getNamespace()); 
    this.withPath(instance.getPath()); 
    this.withResource(instance.getResource()); 
    this.withResourceAPIGroup(instance.getResourceAPIGroup()); 
    this.withResourceAPIVersion(instance.getResourceAPIVersion()); 
    this.withResourceName(instance.getResourceName()); 
    this.withVerb(instance.getVerb()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.LocalResourceAccessReviewFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.LocalResourceAccessReview build() {
    LocalResourceAccessReview buildable = new LocalResourceAccessReview(fluent.getApiVersion(),fluent.getContent(),fluent.getIsNonResourceURL(),fluent.getKind(),fluent.getNamespace(),fluent.getPath(),fluent.getResource(),fluent.getResourceAPIGroup(),fluent.getResourceAPIVersion(),fluent.getResourceName(),fluent.getVerb());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}