package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MaxAgePolicyBuilder extends MaxAgePolicyFluentImpl<MaxAgePolicyBuilder> implements VisitableBuilder<MaxAgePolicy,io.fabric8.openshift.api.model.MaxAgePolicyBuilder>{
  public MaxAgePolicyBuilder() {
    this(false);
  }
  public MaxAgePolicyBuilder(Boolean validationEnabled) {
    this(new MaxAgePolicy(), validationEnabled);
  }
  public MaxAgePolicyBuilder(io.fabric8.openshift.api.model.MaxAgePolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public MaxAgePolicyBuilder(io.fabric8.openshift.api.model.MaxAgePolicyFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new MaxAgePolicy(), validationEnabled);
  }
  public MaxAgePolicyBuilder(io.fabric8.openshift.api.model.MaxAgePolicyFluent<?> fluent,io.fabric8.openshift.api.model.MaxAgePolicy instance) {
    this(fluent, instance, false);
  }
  public MaxAgePolicyBuilder(io.fabric8.openshift.api.model.MaxAgePolicyFluent<?> fluent,io.fabric8.openshift.api.model.MaxAgePolicy instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLargestMaxAge(instance.getLargestMaxAge()); 
    fluent.withSmallestMaxAge(instance.getSmallestMaxAge()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MaxAgePolicyBuilder(io.fabric8.openshift.api.model.MaxAgePolicy instance) {
    this(instance,false);
  }
  public MaxAgePolicyBuilder(io.fabric8.openshift.api.model.MaxAgePolicy instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLargestMaxAge(instance.getLargestMaxAge()); 
    this.withSmallestMaxAge(instance.getSmallestMaxAge()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.MaxAgePolicyFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.MaxAgePolicy build() {
    MaxAgePolicy buildable = new MaxAgePolicy(fluent.getLargestMaxAge(),fluent.getSmallestMaxAge());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}