package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NetNamespaceFluentImpl<A extends NetNamespaceFluent<A>> extends BaseFluent<A> implements NetNamespaceFluent<A>{
  public NetNamespaceFluentImpl() {
  }
  public NetNamespaceFluentImpl(io.fabric8.openshift.api.model.NetNamespace instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withEgressIPs(instance.getEgressIPs()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withNetid(instance.getNetid()); 
    this.withNetname(instance.getNetname()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private List<java.lang.String> egressIPs = new ArrayList<java.lang.String>();
  private java.lang.String kind;
  private ObjectMetaBuilder metadata;
  private Integer netid;
  private java.lang.String netname;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToEgressIPs(java.lang.Integer index,java.lang.String item) {
    if (this.egressIPs == null) {this.egressIPs = new java.util.ArrayList<java.lang.String>();}
    this.egressIPs.add(index, item);
    return (A)this;
  }
  public A setToEgressIPs(java.lang.Integer index,java.lang.String item) {
    if (this.egressIPs == null) {this.egressIPs = new java.util.ArrayList<java.lang.String>();}
    this.egressIPs.set(index, item); return (A)this;
  }
  public A addToEgressIPs(java.lang.String... items) {
    if (this.egressIPs == null) {this.egressIPs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.egressIPs.add(item);} return (A)this;
  }
  public A addAllToEgressIPs(Collection<java.lang.String> items) {
    if (this.egressIPs == null) {this.egressIPs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.egressIPs.add(item);} return (A)this;
  }
  public A removeFromEgressIPs(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.egressIPs!= null){ this.egressIPs.remove(item);}} return (A)this;
  }
  public A removeAllFromEgressIPs(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.egressIPs!= null){ this.egressIPs.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getEgressIPs() {
    return this.egressIPs;
  }
  public java.lang.String getEgressIP(java.lang.Integer index) {
    return this.egressIPs.get(index);
  }
  public java.lang.String getFirstEgressIP() {
    return this.egressIPs.get(0);
  }
  public java.lang.String getLastEgressIP() {
    return this.egressIPs.get(egressIPs.size() - 1);
  }
  public java.lang.String getMatchingEgressIP(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: egressIPs) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingEgressIP(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: egressIPs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEgressIPs(java.util.List<java.lang.String> egressIPs) {
    if (egressIPs != null) {this.egressIPs = new java.util.ArrayList(); for (java.lang.String item : egressIPs){this.addToEgressIPs(item);}} else { this.egressIPs = null;} return (A) this;
  }
  public A withEgressIPs(java.lang.String... egressIPs) {
    if (this.egressIPs != null) {this.egressIPs.clear();}
    if (egressIPs != null) {for (java.lang.String item :egressIPs){ this.addToEgressIPs(item);}} return (A) this;
  }
  public java.lang.Boolean hasEgressIPs() {
    return egressIPs != null && !egressIPs.isEmpty();
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public NetNamespaceFluent.MetadataNested<A> withNewMetadata() {
    return new NetNamespaceFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.openshift.api.model.NetNamespaceFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new NetNamespaceFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.NetNamespaceFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.openshift.api.model.NetNamespaceFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.openshift.api.model.NetNamespaceFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public java.lang.Integer getNetid() {
    return this.netid;
  }
  public A withNetid(java.lang.Integer netid) {
    this.netid=netid; return (A) this;
  }
  public java.lang.Boolean hasNetid() {
    return this.netid != null;
  }
  public java.lang.String getNetname() {
    return this.netname;
  }
  public A withNetname(java.lang.String netname) {
    this.netname=netname; return (A) this;
  }
  public java.lang.Boolean hasNetname() {
    return this.netname != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetNamespaceFluentImpl that = (NetNamespaceFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (egressIPs != null ? !egressIPs.equals(that.egressIPs) :that.egressIPs != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (netid != null ? !netid.equals(that.netid) :that.netid != null) return false;
    if (netname != null ? !netname.equals(that.netname) :that.netname != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  egressIPs,  kind,  metadata,  netid,  netname,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (egressIPs != null && !egressIPs.isEmpty()) { sb.append("egressIPs:"); sb.append(egressIPs + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (netid != null) { sb.append("netid:"); sb.append(netid + ","); }
    if (netname != null) { sb.append("netname:"); sb.append(netname + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<NetNamespaceFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.NetNamespaceFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) NetNamespaceFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}