package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkListBuilder extends NetworkListFluentImpl<NetworkListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.NetworkList,NetworkListBuilder>{
  public NetworkListBuilder() {
    this(false);
  }
  public NetworkListBuilder(Boolean validationEnabled) {
    this(new NetworkList(), validationEnabled);
  }
  public NetworkListBuilder(io.fabric8.openshift.api.model.NetworkListFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkListBuilder(io.fabric8.openshift.api.model.NetworkListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NetworkList(), validationEnabled);
  }
  public NetworkListBuilder(io.fabric8.openshift.api.model.NetworkListFluent<?> fluent,io.fabric8.openshift.api.model.NetworkList instance) {
    this(fluent, instance, false);
  }
  public NetworkListBuilder(io.fabric8.openshift.api.model.NetworkListFluent<?> fluent,io.fabric8.openshift.api.model.NetworkList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetworkListBuilder(io.fabric8.openshift.api.model.NetworkList instance) {
    this(instance,false);
  }
  public NetworkListBuilder(io.fabric8.openshift.api.model.NetworkList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.NetworkListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.NetworkList build() {
    NetworkList buildable = new NetworkList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}