package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkStatusBuilder extends NetworkStatusFluentImpl<NetworkStatusBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.NetworkStatus,NetworkStatusBuilder>{
  public NetworkStatusBuilder() {
    this(false);
  }
  public NetworkStatusBuilder(Boolean validationEnabled) {
    this(new NetworkStatus(), validationEnabled);
  }
  public NetworkStatusBuilder(NetworkStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkStatusBuilder(io.fabric8.openshift.api.model.NetworkStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NetworkStatus(), validationEnabled);
  }
  public NetworkStatusBuilder(io.fabric8.openshift.api.model.NetworkStatusFluent<?> fluent,io.fabric8.openshift.api.model.NetworkStatus instance) {
    this(fluent, instance, false);
  }
  public NetworkStatusBuilder(io.fabric8.openshift.api.model.NetworkStatusFluent<?> fluent,io.fabric8.openshift.api.model.NetworkStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterNetwork(instance.getClusterNetwork()); 
    fluent.withClusterNetworkMTU(instance.getClusterNetworkMTU()); 
    fluent.withMigration(instance.getMigration()); 
    fluent.withNetworkType(instance.getNetworkType()); 
    fluent.withServiceNetwork(instance.getServiceNetwork()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetworkStatusBuilder(io.fabric8.openshift.api.model.NetworkStatus instance) {
    this(instance,false);
  }
  public NetworkStatusBuilder(io.fabric8.openshift.api.model.NetworkStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterNetwork(instance.getClusterNetwork()); 
    this.withClusterNetworkMTU(instance.getClusterNetworkMTU()); 
    this.withMigration(instance.getMigration()); 
    this.withNetworkType(instance.getNetworkType()); 
    this.withServiceNetwork(instance.getServiceNetwork()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.NetworkStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.NetworkStatus build() {
    NetworkStatus buildable = new NetworkStatus(fluent.getClusterNetwork(),fluent.getClusterNetworkMTU(),fluent.getMigration(),fluent.getNetworkType(),fluent.getServiceNetwork());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}