package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NetworkStatusFluentImpl<A extends NetworkStatusFluent<A>> extends BaseFluent<A> implements NetworkStatusFluent<A>{
  public NetworkStatusFluentImpl() {
  }
  public NetworkStatusFluentImpl(io.fabric8.openshift.api.model.NetworkStatus instance) {
    this.withClusterNetwork(instance.getClusterNetwork()); 
    this.withClusterNetworkMTU(instance.getClusterNetworkMTU()); 
    this.withMigration(instance.getMigration()); 
    this.withNetworkType(instance.getNetworkType()); 
    this.withServiceNetwork(instance.getServiceNetwork()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<ClusterNetworkEntryBuilder> clusterNetwork = new java.util.ArrayList<ClusterNetworkEntryBuilder>();
  private Integer clusterNetworkMTU;
  private NetworkMigrationBuilder migration;
  private String networkType;
  private List<java.lang.String> serviceNetwork = new java.util.ArrayList<java.lang.String>();
  private Map<java.lang.String,Object> additionalProperties;
  public A addToClusterNetwork(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterNetworkEntry item) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder>();}
    io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(index >= 0 ? index : _visitables.get("clusterNetwork").size(), builder);this.clusterNetwork.add(index >= 0 ? index : clusterNetwork.size(), builder); return (A)this;
  }
  public A setToClusterNetwork(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterNetworkEntry item) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder>();}
    io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= _visitables.get("clusterNetwork").size()) { _visitables.get("clusterNetwork").add(builder); } else { _visitables.get("clusterNetwork").set(index, builder);}
    if (index < 0 || index >= clusterNetwork.size()) { clusterNetwork.add(builder); } else { clusterNetwork.set(index, builder);}
     return (A)this;
  }
  public A addToClusterNetwork(io.fabric8.openshift.api.model.ClusterNetworkEntry... items) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder>();}
    for (io.fabric8.openshift.api.model.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
  }
  public A addAllToClusterNetwork(Collection<io.fabric8.openshift.api.model.ClusterNetworkEntry> items) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder>();}
    for (io.fabric8.openshift.api.model.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
  }
  public A removeFromClusterNetwork(io.fabric8.openshift.api.model.ClusterNetworkEntry... items) {
    for (io.fabric8.openshift.api.model.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder);if (this.clusterNetwork != null) {this.clusterNetwork.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterNetwork(java.util.Collection<io.fabric8.openshift.api.model.ClusterNetworkEntry> items) {
    for (io.fabric8.openshift.api.model.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder);if (this.clusterNetwork != null) {this.clusterNetwork.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterNetwork(Predicate<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder> predicate) {
    if (clusterNetwork == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder> each = clusterNetwork.iterator();
    final List visitables = _visitables.get("clusterNetwork");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildClusterNetwork instead.
   * @return The buildable object.
   */
  @Deprecated
  public java.util.List<io.fabric8.openshift.api.model.ClusterNetworkEntry> getClusterNetwork() {
    return clusterNetwork != null ? build(clusterNetwork) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.ClusterNetworkEntry> buildClusterNetwork() {
    return clusterNetwork != null ? build(clusterNetwork) : null;
  }
  public io.fabric8.openshift.api.model.ClusterNetworkEntry buildClusterNetwork(java.lang.Integer index) {
    return this.clusterNetwork.get(index).build();
  }
  public io.fabric8.openshift.api.model.ClusterNetworkEntry buildFirstClusterNetwork() {
    return this.clusterNetwork.get(0).build();
  }
  public io.fabric8.openshift.api.model.ClusterNetworkEntry buildLastClusterNetwork() {
    return this.clusterNetwork.get(clusterNetwork.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.ClusterNetworkEntry buildMatchingClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder item: clusterNetwork) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder item: clusterNetwork) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusterNetwork(java.util.List<io.fabric8.openshift.api.model.ClusterNetworkEntry> clusterNetwork) {
    if (this.clusterNetwork != null) { _visitables.get("clusterNetwork").removeAll(this.clusterNetwork);}
    if (clusterNetwork != null) {this.clusterNetwork = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.ClusterNetworkEntry item : clusterNetwork){this.addToClusterNetwork(item);}} else { this.clusterNetwork = null;} return (A) this;
  }
  public A withClusterNetwork(io.fabric8.openshift.api.model.ClusterNetworkEntry... clusterNetwork) {
    if (this.clusterNetwork != null) {this.clusterNetwork.clear();}
    if (clusterNetwork != null) {for (io.fabric8.openshift.api.model.ClusterNetworkEntry item :clusterNetwork){ this.addToClusterNetwork(item);}} return (A) this;
  }
  public java.lang.Boolean hasClusterNetwork() {
    return clusterNetwork != null && !clusterNetwork.isEmpty();
  }
  public A addNewClusterNetwork(java.lang.String cidr,java.lang.Integer hostSubnetLength) {
    return (A)addToClusterNetwork(new ClusterNetworkEntry(cidr, hostSubnetLength));
  }
  public NetworkStatusFluent.ClusterNetworkNested<A> addNewClusterNetwork() {
    return new NetworkStatusFluentImpl.ClusterNetworkNestedImpl();
  }
  public io.fabric8.openshift.api.model.NetworkStatusFluent.ClusterNetworkNested<A> addNewClusterNetworkLike(io.fabric8.openshift.api.model.ClusterNetworkEntry item) {
    return new NetworkStatusFluentImpl.ClusterNetworkNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.NetworkStatusFluent.ClusterNetworkNested<A> setNewClusterNetworkLike(java.lang.Integer index,io.fabric8.openshift.api.model.ClusterNetworkEntry item) {
    return new io.fabric8.openshift.api.model.NetworkStatusFluentImpl.ClusterNetworkNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.NetworkStatusFluent.ClusterNetworkNested<A> editClusterNetwork(java.lang.Integer index) {
    if (clusterNetwork.size() <= index) throw new RuntimeException("Can't edit clusterNetwork. Index exceeds size.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public io.fabric8.openshift.api.model.NetworkStatusFluent.ClusterNetworkNested<A> editFirstClusterNetwork() {
    if (clusterNetwork.size() == 0) throw new RuntimeException("Can't edit first clusterNetwork. The list is empty.");
    return setNewClusterNetworkLike(0, buildClusterNetwork(0));
  }
  public io.fabric8.openshift.api.model.NetworkStatusFluent.ClusterNetworkNested<A> editLastClusterNetwork() {
    int index = clusterNetwork.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterNetwork. The list is empty.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public io.fabric8.openshift.api.model.NetworkStatusFluent.ClusterNetworkNested<A> editMatchingClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterNetwork.size();i++) { 
    if (predicate.test(clusterNetwork.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterNetwork. No match found.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public java.lang.Integer getClusterNetworkMTU() {
    return this.clusterNetworkMTU;
  }
  public A withClusterNetworkMTU(java.lang.Integer clusterNetworkMTU) {
    this.clusterNetworkMTU=clusterNetworkMTU; return (A) this;
  }
  public java.lang.Boolean hasClusterNetworkMTU() {
    return this.clusterNetworkMTU != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMigration instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.NetworkMigration getMigration() {
    return this.migration!=null ?this.migration.build():null;
  }
  public io.fabric8.openshift.api.model.NetworkMigration buildMigration() {
    return this.migration!=null ?this.migration.build():null;
  }
  public A withMigration(io.fabric8.openshift.api.model.NetworkMigration migration) {
    _visitables.get("migration").remove(this.migration);
    if (migration!=null){ this.migration= new NetworkMigrationBuilder(migration); _visitables.get("migration").add(this.migration);} return (A) this;
  }
  public java.lang.Boolean hasMigration() {
    return this.migration != null;
  }
  public A withNewMigration(java.lang.String networkType) {
    return (A)withMigration(new NetworkMigration(networkType));
  }
  public NetworkStatusFluent.MigrationNested<A> withNewMigration() {
    return new NetworkStatusFluentImpl.MigrationNestedImpl();
  }
  public io.fabric8.openshift.api.model.NetworkStatusFluent.MigrationNested<A> withNewMigrationLike(io.fabric8.openshift.api.model.NetworkMigration item) {
    return new io.fabric8.openshift.api.model.NetworkStatusFluentImpl.MigrationNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.NetworkStatusFluent.MigrationNested<A> editMigration() {
    return withNewMigrationLike(getMigration());
  }
  public io.fabric8.openshift.api.model.NetworkStatusFluent.MigrationNested<A> editOrNewMigration() {
    return withNewMigrationLike(getMigration() != null ? getMigration(): new io.fabric8.openshift.api.model.NetworkMigrationBuilder().build());
  }
  public io.fabric8.openshift.api.model.NetworkStatusFluent.MigrationNested<A> editOrNewMigrationLike(io.fabric8.openshift.api.model.NetworkMigration item) {
    return withNewMigrationLike(getMigration() != null ? getMigration(): item);
  }
  public java.lang.String getNetworkType() {
    return this.networkType;
  }
  public A withNetworkType(java.lang.String networkType) {
    this.networkType=networkType; return (A) this;
  }
  public java.lang.Boolean hasNetworkType() {
    return this.networkType != null;
  }
  public A addToServiceNetwork(java.lang.Integer index,java.lang.String item) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>();}
    this.serviceNetwork.add(index, item);
    return (A)this;
  }
  public A setToServiceNetwork(java.lang.Integer index,java.lang.String item) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>();}
    this.serviceNetwork.set(index, item); return (A)this;
  }
  public A addToServiceNetwork(java.lang.String... items) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.serviceNetwork.add(item);} return (A)this;
  }
  public A addAllToServiceNetwork(java.util.Collection<java.lang.String> items) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.serviceNetwork.add(item);} return (A)this;
  }
  public A removeFromServiceNetwork(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.serviceNetwork!= null){ this.serviceNetwork.remove(item);}} return (A)this;
  }
  public A removeAllFromServiceNetwork(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.serviceNetwork!= null){ this.serviceNetwork.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getServiceNetwork() {
    return this.serviceNetwork;
  }
  public java.lang.String getServiceNetwork(java.lang.Integer index) {
    return this.serviceNetwork.get(index);
  }
  public java.lang.String getFirstServiceNetwork() {
    return this.serviceNetwork.get(0);
  }
  public java.lang.String getLastServiceNetwork() {
    return this.serviceNetwork.get(serviceNetwork.size() - 1);
  }
  public java.lang.String getMatchingServiceNetwork(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: serviceNetwork) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingServiceNetwork(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: serviceNetwork) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServiceNetwork(java.util.List<java.lang.String> serviceNetwork) {
    if (serviceNetwork != null) {this.serviceNetwork = new java.util.ArrayList(); for (java.lang.String item : serviceNetwork){this.addToServiceNetwork(item);}} else { this.serviceNetwork = null;} return (A) this;
  }
  public A withServiceNetwork(java.lang.String... serviceNetwork) {
    if (this.serviceNetwork != null) {this.serviceNetwork.clear();}
    if (serviceNetwork != null) {for (java.lang.String item :serviceNetwork){ this.addToServiceNetwork(item);}} return (A) this;
  }
  public java.lang.Boolean hasServiceNetwork() {
    return serviceNetwork != null && !serviceNetwork.isEmpty();
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetworkStatusFluentImpl that = (NetworkStatusFluentImpl) o;
    if (clusterNetwork != null ? !clusterNetwork.equals(that.clusterNetwork) :that.clusterNetwork != null) return false;
    if (clusterNetworkMTU != null ? !clusterNetworkMTU.equals(that.clusterNetworkMTU) :that.clusterNetworkMTU != null) return false;
    if (migration != null ? !migration.equals(that.migration) :that.migration != null) return false;
    if (networkType != null ? !networkType.equals(that.networkType) :that.networkType != null) return false;
    if (serviceNetwork != null ? !serviceNetwork.equals(that.serviceNetwork) :that.serviceNetwork != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clusterNetwork,  clusterNetworkMTU,  migration,  networkType,  serviceNetwork,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterNetwork != null && !clusterNetwork.isEmpty()) { sb.append("clusterNetwork:"); sb.append(clusterNetwork + ","); }
    if (clusterNetworkMTU != null) { sb.append("clusterNetworkMTU:"); sb.append(clusterNetworkMTU + ","); }
    if (migration != null) { sb.append("migration:"); sb.append(migration + ","); }
    if (networkType != null) { sb.append("networkType:"); sb.append(networkType + ","); }
    if (serviceNetwork != null && !serviceNetwork.isEmpty()) { sb.append("serviceNetwork:"); sb.append(serviceNetwork + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ClusterNetworkNestedImpl<N> extends ClusterNetworkEntryFluentImpl<NetworkStatusFluent.ClusterNetworkNested<N>> implements io.fabric8.openshift.api.model.NetworkStatusFluent.ClusterNetworkNested<N>,Nested<N>{
    ClusterNetworkNestedImpl(java.lang.Integer index,ClusterNetworkEntry item) {
      this.index = index;
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterNetworkEntryBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) NetworkStatusFluentImpl.this.setToClusterNetwork(index,builder.build());
    }
    public N endClusterNetwork() {
      return and();
    }
    
  }
  class MigrationNestedImpl<N> extends NetworkMigrationFluentImpl<NetworkStatusFluent.MigrationNested<N>> implements io.fabric8.openshift.api.model.NetworkStatusFluent.MigrationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MigrationNestedImpl(io.fabric8.openshift.api.model.NetworkMigration item) {
      this.builder = new NetworkMigrationBuilder(this, item);
    }
    MigrationNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.NetworkMigrationBuilder(this);
    }
    io.fabric8.openshift.api.model.NetworkMigrationBuilder builder;
    public N and() {
      return (N) NetworkStatusFluentImpl.this.withMigration(builder.build());
    }
    public N endMigration() {
      return and();
    }
    
  }
  
}