package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OAuthClientAuthorizationFluentImpl<A extends OAuthClientAuthorizationFluent<A>> extends BaseFluent<A> implements OAuthClientAuthorizationFluent<A>{
  public OAuthClientAuthorizationFluentImpl() {
  }
  public OAuthClientAuthorizationFluentImpl(io.fabric8.openshift.api.model.OAuthClientAuthorization instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withClientName(instance.getClientName()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withScopes(instance.getScopes()); 
    this.withUserName(instance.getUserName()); 
    this.withUserUID(instance.getUserUID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private java.lang.String clientName;
  private java.lang.String kind;
  private ObjectMetaBuilder metadata;
  private List<java.lang.String> scopes = new ArrayList<java.lang.String>();
  private java.lang.String userName;
  private java.lang.String userUID;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public java.lang.String getClientName() {
    return this.clientName;
  }
  public A withClientName(java.lang.String clientName) {
    this.clientName=clientName; return (A) this;
  }
  public java.lang.Boolean hasClientName() {
    return this.clientName != null;
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public OAuthClientAuthorizationFluent.MetadataNested<A> withNewMetadata() {
    return new OAuthClientAuthorizationFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new OAuthClientAuthorizationFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToScopes(Integer index,java.lang.String item) {
    if (this.scopes == null) {this.scopes = new java.util.ArrayList<java.lang.String>();}
    this.scopes.add(index, item);
    return (A)this;
  }
  public A setToScopes(java.lang.Integer index,java.lang.String item) {
    if (this.scopes == null) {this.scopes = new java.util.ArrayList<java.lang.String>();}
    this.scopes.set(index, item); return (A)this;
  }
  public A addToScopes(java.lang.String... items) {
    if (this.scopes == null) {this.scopes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.scopes.add(item);} return (A)this;
  }
  public A addAllToScopes(Collection<java.lang.String> items) {
    if (this.scopes == null) {this.scopes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.scopes.add(item);} return (A)this;
  }
  public A removeFromScopes(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.scopes!= null){ this.scopes.remove(item);}} return (A)this;
  }
  public A removeAllFromScopes(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.scopes!= null){ this.scopes.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getScopes() {
    return this.scopes;
  }
  public java.lang.String getScope(java.lang.Integer index) {
    return this.scopes.get(index);
  }
  public java.lang.String getFirstScope() {
    return this.scopes.get(0);
  }
  public java.lang.String getLastScope() {
    return this.scopes.get(scopes.size() - 1);
  }
  public java.lang.String getMatchingScope(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: scopes) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingScope(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: scopes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withScopes(java.util.List<java.lang.String> scopes) {
    if (scopes != null) {this.scopes = new java.util.ArrayList(); for (java.lang.String item : scopes){this.addToScopes(item);}} else { this.scopes = null;} return (A) this;
  }
  public A withScopes(java.lang.String... scopes) {
    if (this.scopes != null) {this.scopes.clear();}
    if (scopes != null) {for (java.lang.String item :scopes){ this.addToScopes(item);}} return (A) this;
  }
  public java.lang.Boolean hasScopes() {
    return scopes != null && !scopes.isEmpty();
  }
  public java.lang.String getUserName() {
    return this.userName;
  }
  public A withUserName(java.lang.String userName) {
    this.userName=userName; return (A) this;
  }
  public java.lang.Boolean hasUserName() {
    return this.userName != null;
  }
  public java.lang.String getUserUID() {
    return this.userUID;
  }
  public A withUserUID(java.lang.String userUID) {
    this.userUID=userUID; return (A) this;
  }
  public java.lang.Boolean hasUserUID() {
    return this.userUID != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OAuthClientAuthorizationFluentImpl that = (OAuthClientAuthorizationFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (clientName != null ? !clientName.equals(that.clientName) :that.clientName != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (scopes != null ? !scopes.equals(that.scopes) :that.scopes != null) return false;
    if (userName != null ? !userName.equals(that.userName) :that.userName != null) return false;
    if (userUID != null ? !userUID.equals(that.userUID) :that.userUID != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  clientName,  kind,  metadata,  scopes,  userName,  userUID,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (clientName != null) { sb.append("clientName:"); sb.append(clientName + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (scopes != null && !scopes.isEmpty()) { sb.append("scopes:"); sb.append(scopes + ","); }
    if (userName != null) { sb.append("userName:"); sb.append(userName + ","); }
    if (userUID != null) { sb.append("userUID:"); sb.append(userUID + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<OAuthClientAuthorizationFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) OAuthClientAuthorizationFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}