package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuthClientAuthorizationListBuilder extends OAuthClientAuthorizationListFluentImpl<OAuthClientAuthorizationListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.OAuthClientAuthorizationList,io.fabric8.openshift.api.model.OAuthClientAuthorizationListBuilder>{
  public OAuthClientAuthorizationListBuilder() {
    this(false);
  }
  public OAuthClientAuthorizationListBuilder(Boolean validationEnabled) {
    this(new OAuthClientAuthorizationList(), validationEnabled);
  }
  public OAuthClientAuthorizationListBuilder(OAuthClientAuthorizationListFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthClientAuthorizationListBuilder(io.fabric8.openshift.api.model.OAuthClientAuthorizationListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OAuthClientAuthorizationList(), validationEnabled);
  }
  public OAuthClientAuthorizationListBuilder(io.fabric8.openshift.api.model.OAuthClientAuthorizationListFluent<?> fluent,io.fabric8.openshift.api.model.OAuthClientAuthorizationList instance) {
    this(fluent, instance, false);
  }
  public OAuthClientAuthorizationListBuilder(io.fabric8.openshift.api.model.OAuthClientAuthorizationListFluent<?> fluent,io.fabric8.openshift.api.model.OAuthClientAuthorizationList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OAuthClientAuthorizationListBuilder(io.fabric8.openshift.api.model.OAuthClientAuthorizationList instance) {
    this(instance,false);
  }
  public OAuthClientAuthorizationListBuilder(io.fabric8.openshift.api.model.OAuthClientAuthorizationList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.OAuthClientAuthorizationListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.OAuthClientAuthorizationList build() {
    OAuthClientAuthorizationList buildable = new OAuthClientAuthorizationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}