package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface OAuthClientFluent<A extends OAuthClientFluent<A>> extends Fluent<A>{
  public Integer getAccessTokenInactivityTimeoutSeconds();
  public A withAccessTokenInactivityTimeoutSeconds(java.lang.Integer accessTokenInactivityTimeoutSeconds);
  public Boolean hasAccessTokenInactivityTimeoutSeconds();
  public java.lang.Integer getAccessTokenMaxAgeSeconds();
  public A withAccessTokenMaxAgeSeconds(java.lang.Integer accessTokenMaxAgeSeconds);
  public java.lang.Boolean hasAccessTokenMaxAgeSeconds();
  public A addToAdditionalSecrets(java.lang.Integer index,String item);
  public A setToAdditionalSecrets(java.lang.Integer index,java.lang.String item);
  public A addToAdditionalSecrets(java.lang.String... items);
  public A addAllToAdditionalSecrets(Collection<java.lang.String> items);
  public A removeFromAdditionalSecrets(java.lang.String... items);
  public A removeAllFromAdditionalSecrets(java.util.Collection<java.lang.String> items);
  public List<java.lang.String> getAdditionalSecrets();
  public java.lang.String getAdditionalSecret(java.lang.Integer index);
  public java.lang.String getFirstAdditionalSecret();
  public java.lang.String getLastAdditionalSecret();
  public java.lang.String getMatchingAdditionalSecret(Predicate<java.lang.String> predicate);
  public java.lang.Boolean hasMatchingAdditionalSecret(java.util.function.Predicate<java.lang.String> predicate);
  public A withAdditionalSecrets(java.util.List<java.lang.String> additionalSecrets);
  public A withAdditionalSecrets(java.lang.String... additionalSecrets);
  public java.lang.Boolean hasAdditionalSecrets();
  public java.lang.String getApiVersion();
  public A withApiVersion(java.lang.String apiVersion);
  public java.lang.Boolean hasApiVersion();
  public java.lang.String getGrantMethod();
  public A withGrantMethod(java.lang.String grantMethod);
  public java.lang.Boolean hasGrantMethod();
  public java.lang.String getKind();
  public A withKind(java.lang.String kind);
  public java.lang.Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata();
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata);
  public java.lang.Boolean hasMetadata();
  public OAuthClientFluent.MetadataNested<A> withNewMetadata();
  public io.fabric8.openshift.api.model.OAuthClientFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item);
  public io.fabric8.openshift.api.model.OAuthClientFluent.MetadataNested<A> editMetadata();
  public io.fabric8.openshift.api.model.OAuthClientFluent.MetadataNested<A> editOrNewMetadata();
  public io.fabric8.openshift.api.model.OAuthClientFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item);
  public A addToRedirectURIs(java.lang.Integer index,java.lang.String item);
  public A setToRedirectURIs(java.lang.Integer index,java.lang.String item);
  public A addToRedirectURIs(java.lang.String... items);
  public A addAllToRedirectURIs(java.util.Collection<java.lang.String> items);
  public A removeFromRedirectURIs(java.lang.String... items);
  public A removeAllFromRedirectURIs(java.util.Collection<java.lang.String> items);
  public java.util.List<java.lang.String> getRedirectURIs();
  public java.lang.String getRedirectURI(java.lang.Integer index);
  public java.lang.String getFirstRedirectURI();
  public java.lang.String getLastRedirectURI();
  public java.lang.String getMatchingRedirectURI(java.util.function.Predicate<java.lang.String> predicate);
  public java.lang.Boolean hasMatchingRedirectURI(java.util.function.Predicate<java.lang.String> predicate);
  public A withRedirectURIs(java.util.List<java.lang.String> redirectURIs);
  public A withRedirectURIs(java.lang.String... redirectURIs);
  public java.lang.Boolean hasRedirectURIs();
  public java.lang.Boolean getRespondWithChallenges();
  public A withRespondWithChallenges(java.lang.Boolean respondWithChallenges);
  public java.lang.Boolean hasRespondWithChallenges();
  public A addToScopeRestrictions(java.lang.Integer index,ScopeRestriction item);
  public A setToScopeRestrictions(java.lang.Integer index,io.fabric8.openshift.api.model.ScopeRestriction item);
  public A addToScopeRestrictions(io.fabric8.openshift.api.model.ScopeRestriction... items);
  public A addAllToScopeRestrictions(java.util.Collection<io.fabric8.openshift.api.model.ScopeRestriction> items);
  public A removeFromScopeRestrictions(io.fabric8.openshift.api.model.ScopeRestriction... items);
  public A removeAllFromScopeRestrictions(java.util.Collection<io.fabric8.openshift.api.model.ScopeRestriction> items);
  public A removeMatchingFromScopeRestrictions(java.util.function.Predicate<ScopeRestrictionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildScopeRestrictions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.ScopeRestriction> getScopeRestrictions();
  public java.util.List<io.fabric8.openshift.api.model.ScopeRestriction> buildScopeRestrictions();
  public io.fabric8.openshift.api.model.ScopeRestriction buildScopeRestriction(java.lang.Integer index);
  public io.fabric8.openshift.api.model.ScopeRestriction buildFirstScopeRestriction();
  public io.fabric8.openshift.api.model.ScopeRestriction buildLastScopeRestriction();
  public io.fabric8.openshift.api.model.ScopeRestriction buildMatchingScopeRestriction(java.util.function.Predicate<io.fabric8.openshift.api.model.ScopeRestrictionBuilder> predicate);
  public java.lang.Boolean hasMatchingScopeRestriction(java.util.function.Predicate<io.fabric8.openshift.api.model.ScopeRestrictionBuilder> predicate);
  public A withScopeRestrictions(java.util.List<io.fabric8.openshift.api.model.ScopeRestriction> scopeRestrictions);
  public A withScopeRestrictions(io.fabric8.openshift.api.model.ScopeRestriction... scopeRestrictions);
  public java.lang.Boolean hasScopeRestrictions();
  public OAuthClientFluent.ScopeRestrictionsNested<A> addNewScopeRestriction();
  public io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<A> addNewScopeRestrictionLike(io.fabric8.openshift.api.model.ScopeRestriction item);
  public io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<A> setNewScopeRestrictionLike(java.lang.Integer index,io.fabric8.openshift.api.model.ScopeRestriction item);
  public io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<A> editScopeRestriction(java.lang.Integer index);
  public io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<A> editFirstScopeRestriction();
  public io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<A> editLastScopeRestriction();
  public io.fabric8.openshift.api.model.OAuthClientFluent.ScopeRestrictionsNested<A> editMatchingScopeRestriction(java.util.function.Predicate<io.fabric8.openshift.api.model.ScopeRestrictionBuilder> predicate);
  public java.lang.String getSecret();
  public A withSecret(java.lang.String secret);
  public java.lang.Boolean hasSecret();
  public A addToAdditionalProperties(java.lang.String key,Object value);
  public A addToAdditionalProperties(Map<java.lang.String,java.lang.Object> map);
  public A removeFromAdditionalProperties(java.lang.String key);
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map);
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties);
  public java.lang.Boolean hasAdditionalProperties();
  public A withRespondWithChallenges();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<OAuthClientFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface ScopeRestrictionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ScopeRestrictionFluent<OAuthClientFluent.ScopeRestrictionsNested<N>>{
    public N and();
    public N endScopeRestriction();
    
  }
  
}