package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuthSpecBuilder extends OAuthSpecFluentImpl<OAuthSpecBuilder> implements VisitableBuilder<OAuthSpec,io.fabric8.openshift.api.model.OAuthSpecBuilder>{
  public OAuthSpecBuilder() {
    this(false);
  }
  public OAuthSpecBuilder(Boolean validationEnabled) {
    this(new OAuthSpec(), validationEnabled);
  }
  public OAuthSpecBuilder(OAuthSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthSpecBuilder(io.fabric8.openshift.api.model.OAuthSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OAuthSpec(), validationEnabled);
  }
  public OAuthSpecBuilder(io.fabric8.openshift.api.model.OAuthSpecFluent<?> fluent,io.fabric8.openshift.api.model.OAuthSpec instance) {
    this(fluent, instance, false);
  }
  public OAuthSpecBuilder(io.fabric8.openshift.api.model.OAuthSpecFluent<?> fluent,io.fabric8.openshift.api.model.OAuthSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withIdentityProviders(instance.getIdentityProviders()); 
    fluent.withTemplates(instance.getTemplates()); 
    fluent.withTokenConfig(instance.getTokenConfig()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OAuthSpecBuilder(io.fabric8.openshift.api.model.OAuthSpec instance) {
    this(instance,false);
  }
  public OAuthSpecBuilder(io.fabric8.openshift.api.model.OAuthSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withIdentityProviders(instance.getIdentityProviders()); 
    this.withTemplates(instance.getTemplates()); 
    this.withTokenConfig(instance.getTokenConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.OAuthSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.OAuthSpec build() {
    OAuthSpec buildable = new OAuthSpec(fluent.getIdentityProviders(),fluent.getTemplates(),fluent.getTokenConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}