package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuthStatusBuilder extends OAuthStatusFluentImpl<OAuthStatusBuilder> implements VisitableBuilder<OAuthStatus,io.fabric8.openshift.api.model.OAuthStatusBuilder>{
  public OAuthStatusBuilder() {
    this(false);
  }
  public OAuthStatusBuilder(Boolean validationEnabled) {
    this(new OAuthStatus(), validationEnabled);
  }
  public OAuthStatusBuilder(OAuthStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthStatusBuilder(io.fabric8.openshift.api.model.OAuthStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OAuthStatus(), validationEnabled);
  }
  public OAuthStatusBuilder(io.fabric8.openshift.api.model.OAuthStatusFluent<?> fluent,io.fabric8.openshift.api.model.OAuthStatus instance) {
    this(fluent, instance, false);
  }
  public OAuthStatusBuilder(io.fabric8.openshift.api.model.OAuthStatusFluent<?> fluent,io.fabric8.openshift.api.model.OAuthStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OAuthStatusBuilder(io.fabric8.openshift.api.model.OAuthStatus instance) {
    this(instance,false);
  }
  public OAuthStatusBuilder(io.fabric8.openshift.api.model.OAuthStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.OAuthStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.OAuthStatus build() {
    OAuthStatus buildable = new OAuthStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}