package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuthTemplatesBuilder extends OAuthTemplatesFluentImpl<OAuthTemplatesBuilder> implements VisitableBuilder<OAuthTemplates,io.fabric8.openshift.api.model.OAuthTemplatesBuilder>{
  public OAuthTemplatesBuilder() {
    this(false);
  }
  public OAuthTemplatesBuilder(Boolean validationEnabled) {
    this(new OAuthTemplates(), validationEnabled);
  }
  public OAuthTemplatesBuilder(io.fabric8.openshift.api.model.OAuthTemplatesFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthTemplatesBuilder(io.fabric8.openshift.api.model.OAuthTemplatesFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OAuthTemplates(), validationEnabled);
  }
  public OAuthTemplatesBuilder(io.fabric8.openshift.api.model.OAuthTemplatesFluent<?> fluent,io.fabric8.openshift.api.model.OAuthTemplates instance) {
    this(fluent, instance, false);
  }
  public OAuthTemplatesBuilder(io.fabric8.openshift.api.model.OAuthTemplatesFluent<?> fluent,io.fabric8.openshift.api.model.OAuthTemplates instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withError(instance.getError()); 
    fluent.withLogin(instance.getLogin()); 
    fluent.withProviderSelection(instance.getProviderSelection()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OAuthTemplatesBuilder(io.fabric8.openshift.api.model.OAuthTemplates instance) {
    this(instance,false);
  }
  public OAuthTemplatesBuilder(io.fabric8.openshift.api.model.OAuthTemplates instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withError(instance.getError()); 
    this.withLogin(instance.getLogin()); 
    this.withProviderSelection(instance.getProviderSelection()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.OAuthTemplatesFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.OAuthTemplates build() {
    OAuthTemplates buildable = new OAuthTemplates(fluent.getError(),fluent.getLogin(),fluent.getProviderSelection());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}