package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenIDClaimsBuilder extends OpenIDClaimsFluentImpl<OpenIDClaimsBuilder> implements VisitableBuilder<OpenIDClaims,io.fabric8.openshift.api.model.OpenIDClaimsBuilder>{
  public OpenIDClaimsBuilder() {
    this(false);
  }
  public OpenIDClaimsBuilder(Boolean validationEnabled) {
    this(new OpenIDClaims(), validationEnabled);
  }
  public OpenIDClaimsBuilder(OpenIDClaimsFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenIDClaimsBuilder(io.fabric8.openshift.api.model.OpenIDClaimsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OpenIDClaims(), validationEnabled);
  }
  public OpenIDClaimsBuilder(io.fabric8.openshift.api.model.OpenIDClaimsFluent<?> fluent,io.fabric8.openshift.api.model.OpenIDClaims instance) {
    this(fluent, instance, false);
  }
  public OpenIDClaimsBuilder(io.fabric8.openshift.api.model.OpenIDClaimsFluent<?> fluent,io.fabric8.openshift.api.model.OpenIDClaims instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEmail(instance.getEmail()); 
    fluent.withGroups(instance.getGroups()); 
    fluent.withName(instance.getName()); 
    fluent.withPreferredUsername(instance.getPreferredUsername()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OpenIDClaimsBuilder(io.fabric8.openshift.api.model.OpenIDClaims instance) {
    this(instance,false);
  }
  public OpenIDClaimsBuilder(io.fabric8.openshift.api.model.OpenIDClaims instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withEmail(instance.getEmail()); 
    this.withGroups(instance.getGroups()); 
    this.withName(instance.getName()); 
    this.withPreferredUsername(instance.getPreferredUsername()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.OpenIDClaimsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.OpenIDClaims build() {
    OpenIDClaims buildable = new OpenIDClaims(fluent.getEmail(),fluent.getGroups(),fluent.getName(),fluent.getPreferredUsername());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}