package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenStackPlatformStatusBuilder extends OpenStackPlatformStatusFluentImpl<OpenStackPlatformStatusBuilder> implements VisitableBuilder<OpenStackPlatformStatus,io.fabric8.openshift.api.model.OpenStackPlatformStatusBuilder>{
  public OpenStackPlatformStatusBuilder() {
    this(false);
  }
  public OpenStackPlatformStatusBuilder(Boolean validationEnabled) {
    this(new OpenStackPlatformStatus(), validationEnabled);
  }
  public OpenStackPlatformStatusBuilder(OpenStackPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenStackPlatformStatusBuilder(io.fabric8.openshift.api.model.OpenStackPlatformStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OpenStackPlatformStatus(), validationEnabled);
  }
  public OpenStackPlatformStatusBuilder(io.fabric8.openshift.api.model.OpenStackPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.OpenStackPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public OpenStackPlatformStatusBuilder(io.fabric8.openshift.api.model.OpenStackPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.OpenStackPlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiServerInternalIP(instance.getApiServerInternalIP()); 
    fluent.withCloudName(instance.getCloudName()); 
    fluent.withIngressIP(instance.getIngressIP()); 
    fluent.withNodeDNSIP(instance.getNodeDNSIP()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OpenStackPlatformStatusBuilder(io.fabric8.openshift.api.model.OpenStackPlatformStatus instance) {
    this(instance,false);
  }
  public OpenStackPlatformStatusBuilder(io.fabric8.openshift.api.model.OpenStackPlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiServerInternalIP(instance.getApiServerInternalIP()); 
    this.withCloudName(instance.getCloudName()); 
    this.withIngressIP(instance.getIngressIP()); 
    this.withNodeDNSIP(instance.getNodeDNSIP()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.OpenStackPlatformStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.OpenStackPlatformStatus build() {
    OpenStackPlatformStatus buildable = new OpenStackPlatformStatus(fluent.getApiServerInternalIP(),fluent.getCloudName(),fluent.getIngressIP(),fluent.getNodeDNSIP());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}