package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperandVersionBuilder extends OperandVersionFluentImpl<OperandVersionBuilder> implements VisitableBuilder<OperandVersion,io.fabric8.openshift.api.model.OperandVersionBuilder>{
  public OperandVersionBuilder() {
    this(false);
  }
  public OperandVersionBuilder(Boolean validationEnabled) {
    this(new OperandVersion(), validationEnabled);
  }
  public OperandVersionBuilder(io.fabric8.openshift.api.model.OperandVersionFluent<?> fluent) {
    this(fluent, false);
  }
  public OperandVersionBuilder(io.fabric8.openshift.api.model.OperandVersionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OperandVersion(), validationEnabled);
  }
  public OperandVersionBuilder(io.fabric8.openshift.api.model.OperandVersionFluent<?> fluent,io.fabric8.openshift.api.model.OperandVersion instance) {
    this(fluent, instance, false);
  }
  public OperandVersionBuilder(io.fabric8.openshift.api.model.OperandVersionFluent<?> fluent,io.fabric8.openshift.api.model.OperandVersion instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OperandVersionBuilder(io.fabric8.openshift.api.model.OperandVersion instance) {
    this(instance,false);
  }
  public OperandVersionBuilder(io.fabric8.openshift.api.model.OperandVersion instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.OperandVersionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.OperandVersion build() {
    OperandVersion buildable = new OperandVersion(fluent.getName(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}