package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorHubBuilder extends OperatorHubFluentImpl<OperatorHubBuilder> implements VisitableBuilder<OperatorHub,io.fabric8.openshift.api.model.OperatorHubBuilder>{
  public OperatorHubBuilder() {
    this(false);
  }
  public OperatorHubBuilder(Boolean validationEnabled) {
    this(new OperatorHub(), validationEnabled);
  }
  public OperatorHubBuilder(io.fabric8.openshift.api.model.OperatorHubFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorHubBuilder(io.fabric8.openshift.api.model.OperatorHubFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OperatorHub(), validationEnabled);
  }
  public OperatorHubBuilder(io.fabric8.openshift.api.model.OperatorHubFluent<?> fluent,io.fabric8.openshift.api.model.OperatorHub instance) {
    this(fluent, instance, false);
  }
  public OperatorHubBuilder(io.fabric8.openshift.api.model.OperatorHubFluent<?> fluent,io.fabric8.openshift.api.model.OperatorHub instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OperatorHubBuilder(io.fabric8.openshift.api.model.OperatorHub instance) {
    this(instance,false);
  }
  public OperatorHubBuilder(io.fabric8.openshift.api.model.OperatorHub instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.OperatorHubFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.OperatorHub build() {
    OperatorHub buildable = new OperatorHub(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}