package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorHubListBuilder extends OperatorHubListFluentImpl<OperatorHubListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.OperatorHubList,io.fabric8.openshift.api.model.OperatorHubListBuilder>{
  public OperatorHubListBuilder() {
    this(false);
  }
  public OperatorHubListBuilder(Boolean validationEnabled) {
    this(new OperatorHubList(), validationEnabled);
  }
  public OperatorHubListBuilder(OperatorHubListFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorHubListBuilder(io.fabric8.openshift.api.model.OperatorHubListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OperatorHubList(), validationEnabled);
  }
  public OperatorHubListBuilder(io.fabric8.openshift.api.model.OperatorHubListFluent<?> fluent,io.fabric8.openshift.api.model.OperatorHubList instance) {
    this(fluent, instance, false);
  }
  public OperatorHubListBuilder(io.fabric8.openshift.api.model.OperatorHubListFluent<?> fluent,io.fabric8.openshift.api.model.OperatorHubList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OperatorHubListBuilder(io.fabric8.openshift.api.model.OperatorHubList instance) {
    this(instance,false);
  }
  public OperatorHubListBuilder(io.fabric8.openshift.api.model.OperatorHubList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.OperatorHubListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.OperatorHubList build() {
    OperatorHubList buildable = new OperatorHubList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}