package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OvirtPlatformStatusBuilder extends OvirtPlatformStatusFluentImpl<OvirtPlatformStatusBuilder> implements VisitableBuilder<OvirtPlatformStatus,io.fabric8.openshift.api.model.OvirtPlatformStatusBuilder>{
  public OvirtPlatformStatusBuilder() {
    this(false);
  }
  public OvirtPlatformStatusBuilder(Boolean validationEnabled) {
    this(new OvirtPlatformStatus(), validationEnabled);
  }
  public OvirtPlatformStatusBuilder(OvirtPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public OvirtPlatformStatusBuilder(io.fabric8.openshift.api.model.OvirtPlatformStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OvirtPlatformStatus(), validationEnabled);
  }
  public OvirtPlatformStatusBuilder(io.fabric8.openshift.api.model.OvirtPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.OvirtPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public OvirtPlatformStatusBuilder(io.fabric8.openshift.api.model.OvirtPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.OvirtPlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiServerInternalIP(instance.getApiServerInternalIP()); 
    fluent.withIngressIP(instance.getIngressIP()); 
    fluent.withNodeDNSIP(instance.getNodeDNSIP()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OvirtPlatformStatusBuilder(io.fabric8.openshift.api.model.OvirtPlatformStatus instance) {
    this(instance,false);
  }
  public OvirtPlatformStatusBuilder(io.fabric8.openshift.api.model.OvirtPlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiServerInternalIP(instance.getApiServerInternalIP()); 
    this.withIngressIP(instance.getIngressIP()); 
    this.withNodeDNSIP(instance.getNodeDNSIP()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.OvirtPlatformStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.OvirtPlatformStatus build() {
    OvirtPlatformStatus buildable = new OvirtPlatformStatus(fluent.getApiServerInternalIP(),fluent.getIngressIP(),fluent.getNodeDNSIP());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}