package io.fabric8.openshift.api.model;

import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlatformSpecFluentImpl<A extends PlatformSpecFluent<A>> extends BaseFluent<A> implements PlatformSpecFluent<A>{
  public PlatformSpecFluentImpl() {
  }
  public PlatformSpecFluentImpl(io.fabric8.openshift.api.model.PlatformSpec instance) {
    this.withAlibabaCloud(instance.getAlibabaCloud()); 
    this.withAws(instance.getAws()); 
    this.withAzure(instance.getAzure()); 
    this.withBaremetal(instance.getBaremetal()); 
    this.withEquinixMetal(instance.getEquinixMetal()); 
    this.withGcp(instance.getGcp()); 
    this.withIbmcloud(instance.getIbmcloud()); 
    this.withKubevirt(instance.getKubevirt()); 
    this.withOpenstack(instance.getOpenstack()); 
    this.withOvirt(instance.getOvirt()); 
    this.withPowervs(instance.getPowervs()); 
    this.withType(instance.getType()); 
    this.withVsphere(instance.getVsphere()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private AlibabaCloudPlatformSpecBuilder alibabaCloud;
  private AWSPlatformSpecBuilder aws;
  private AzurePlatformSpecBuilder azure;
  private BareMetalPlatformSpecBuilder baremetal;
  private EquinixMetalPlatformSpecBuilder equinixMetal;
  private GCPPlatformSpecBuilder gcp;
  private IBMCloudPlatformSpecBuilder ibmcloud;
  private KubevirtPlatformSpecBuilder kubevirt;
  private OpenStackPlatformSpecBuilder openstack;
  private OvirtPlatformSpecBuilder ovirt;
  private PowerVSPlatformSpecBuilder powervs;
  private String type;
  private VSpherePlatformSpecBuilder vsphere;
  private Map<java.lang.String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAlibabaCloud instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.openshift.api.model.AlibabaCloudPlatformSpec getAlibabaCloud() {
    return this.alibabaCloud!=null ?this.alibabaCloud.build():null;
  }
  public io.fabric8.openshift.api.model.AlibabaCloudPlatformSpec buildAlibabaCloud() {
    return this.alibabaCloud!=null ?this.alibabaCloud.build():null;
  }
  public A withAlibabaCloud(io.fabric8.openshift.api.model.AlibabaCloudPlatformSpec alibabaCloud) {
    _visitables.get("alibabaCloud").remove(this.alibabaCloud);
    if (alibabaCloud!=null){ this.alibabaCloud= new AlibabaCloudPlatformSpecBuilder(alibabaCloud); _visitables.get("alibabaCloud").add(this.alibabaCloud);} return (A) this;
  }
  public Boolean hasAlibabaCloud() {
    return this.alibabaCloud != null;
  }
  public PlatformSpecFluent.AlibabaCloudNested<A> withNewAlibabaCloud() {
    return new PlatformSpecFluentImpl.AlibabaCloudNestedImpl();
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.AlibabaCloudNested<A> withNewAlibabaCloudLike(io.fabric8.openshift.api.model.AlibabaCloudPlatformSpec item) {
    return new PlatformSpecFluentImpl.AlibabaCloudNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.AlibabaCloudNested<A> editAlibabaCloud() {
    return withNewAlibabaCloudLike(getAlibabaCloud());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.AlibabaCloudNested<A> editOrNewAlibabaCloud() {
    return withNewAlibabaCloudLike(getAlibabaCloud() != null ? getAlibabaCloud(): new io.fabric8.openshift.api.model.AlibabaCloudPlatformSpecBuilder().build());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.AlibabaCloudNested<A> editOrNewAlibabaCloudLike(io.fabric8.openshift.api.model.AlibabaCloudPlatformSpec item) {
    return withNewAlibabaCloudLike(getAlibabaCloud() != null ? getAlibabaCloud(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAws instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public AWSPlatformSpec getAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  public io.fabric8.openshift.api.model.AWSPlatformSpec buildAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  public A withAws(io.fabric8.openshift.api.model.AWSPlatformSpec aws) {
    _visitables.get("aws").remove(this.aws);
    if (aws!=null){ this.aws= new io.fabric8.openshift.api.model.AWSPlatformSpecBuilder(aws); _visitables.get("aws").add(this.aws);} return (A) this;
  }
  public java.lang.Boolean hasAws() {
    return this.aws != null;
  }
  public PlatformSpecFluent.AwsNested<A> withNewAws() {
    return new PlatformSpecFluentImpl.AwsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.AwsNested<A> withNewAwsLike(io.fabric8.openshift.api.model.AWSPlatformSpec item) {
    return new io.fabric8.openshift.api.model.PlatformSpecFluentImpl.AwsNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.AwsNested<A> editAws() {
    return withNewAwsLike(getAws());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.AwsNested<A> editOrNewAws() {
    return withNewAwsLike(getAws() != null ? getAws(): new io.fabric8.openshift.api.model.AWSPlatformSpecBuilder().build());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.AwsNested<A> editOrNewAwsLike(io.fabric8.openshift.api.model.AWSPlatformSpec item) {
    return withNewAwsLike(getAws() != null ? getAws(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAzure instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.AzurePlatformSpec getAzure() {
    return this.azure!=null ?this.azure.build():null;
  }
  public io.fabric8.openshift.api.model.AzurePlatformSpec buildAzure() {
    return this.azure!=null ?this.azure.build():null;
  }
  public A withAzure(io.fabric8.openshift.api.model.AzurePlatformSpec azure) {
    _visitables.get("azure").remove(this.azure);
    if (azure!=null){ this.azure= new AzurePlatformSpecBuilder(azure); _visitables.get("azure").add(this.azure);} return (A) this;
  }
  public java.lang.Boolean hasAzure() {
    return this.azure != null;
  }
  public PlatformSpecFluent.AzureNested<A> withNewAzure() {
    return new PlatformSpecFluentImpl.AzureNestedImpl();
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.AzureNested<A> withNewAzureLike(io.fabric8.openshift.api.model.AzurePlatformSpec item) {
    return new io.fabric8.openshift.api.model.PlatformSpecFluentImpl.AzureNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.AzureNested<A> editAzure() {
    return withNewAzureLike(getAzure());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.AzureNested<A> editOrNewAzure() {
    return withNewAzureLike(getAzure() != null ? getAzure(): new io.fabric8.openshift.api.model.AzurePlatformSpecBuilder().build());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.AzureNested<A> editOrNewAzureLike(io.fabric8.openshift.api.model.AzurePlatformSpec item) {
    return withNewAzureLike(getAzure() != null ? getAzure(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildBaremetal instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public BareMetalPlatformSpec getBaremetal() {
    return this.baremetal!=null ?this.baremetal.build():null;
  }
  public io.fabric8.openshift.api.model.BareMetalPlatformSpec buildBaremetal() {
    return this.baremetal!=null ?this.baremetal.build():null;
  }
  public A withBaremetal(io.fabric8.openshift.api.model.BareMetalPlatformSpec baremetal) {
    _visitables.get("baremetal").remove(this.baremetal);
    if (baremetal!=null){ this.baremetal= new io.fabric8.openshift.api.model.BareMetalPlatformSpecBuilder(baremetal); _visitables.get("baremetal").add(this.baremetal);} return (A) this;
  }
  public java.lang.Boolean hasBaremetal() {
    return this.baremetal != null;
  }
  public PlatformSpecFluent.BaremetalNested<A> withNewBaremetal() {
    return new PlatformSpecFluentImpl.BaremetalNestedImpl();
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.BaremetalNested<A> withNewBaremetalLike(io.fabric8.openshift.api.model.BareMetalPlatformSpec item) {
    return new io.fabric8.openshift.api.model.PlatformSpecFluentImpl.BaremetalNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.BaremetalNested<A> editBaremetal() {
    return withNewBaremetalLike(getBaremetal());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.BaremetalNested<A> editOrNewBaremetal() {
    return withNewBaremetalLike(getBaremetal() != null ? getBaremetal(): new io.fabric8.openshift.api.model.BareMetalPlatformSpecBuilder().build());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.BaremetalNested<A> editOrNewBaremetalLike(io.fabric8.openshift.api.model.BareMetalPlatformSpec item) {
    return withNewBaremetalLike(getBaremetal() != null ? getBaremetal(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEquinixMetal instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public EquinixMetalPlatformSpec getEquinixMetal() {
    return this.equinixMetal!=null ?this.equinixMetal.build():null;
  }
  public io.fabric8.openshift.api.model.EquinixMetalPlatformSpec buildEquinixMetal() {
    return this.equinixMetal!=null ?this.equinixMetal.build():null;
  }
  public A withEquinixMetal(io.fabric8.openshift.api.model.EquinixMetalPlatformSpec equinixMetal) {
    _visitables.get("equinixMetal").remove(this.equinixMetal);
    if (equinixMetal!=null){ this.equinixMetal= new io.fabric8.openshift.api.model.EquinixMetalPlatformSpecBuilder(equinixMetal); _visitables.get("equinixMetal").add(this.equinixMetal);} return (A) this;
  }
  public java.lang.Boolean hasEquinixMetal() {
    return this.equinixMetal != null;
  }
  public PlatformSpecFluent.EquinixMetalNested<A> withNewEquinixMetal() {
    return new PlatformSpecFluentImpl.EquinixMetalNestedImpl();
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.EquinixMetalNested<A> withNewEquinixMetalLike(io.fabric8.openshift.api.model.EquinixMetalPlatformSpec item) {
    return new io.fabric8.openshift.api.model.PlatformSpecFluentImpl.EquinixMetalNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.EquinixMetalNested<A> editEquinixMetal() {
    return withNewEquinixMetalLike(getEquinixMetal());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.EquinixMetalNested<A> editOrNewEquinixMetal() {
    return withNewEquinixMetalLike(getEquinixMetal() != null ? getEquinixMetal(): new io.fabric8.openshift.api.model.EquinixMetalPlatformSpecBuilder().build());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.EquinixMetalNested<A> editOrNewEquinixMetalLike(io.fabric8.openshift.api.model.EquinixMetalPlatformSpec item) {
    return withNewEquinixMetalLike(getEquinixMetal() != null ? getEquinixMetal(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGcp instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public GCPPlatformSpec getGcp() {
    return this.gcp!=null ?this.gcp.build():null;
  }
  public io.fabric8.openshift.api.model.GCPPlatformSpec buildGcp() {
    return this.gcp!=null ?this.gcp.build():null;
  }
  public A withGcp(io.fabric8.openshift.api.model.GCPPlatformSpec gcp) {
    _visitables.get("gcp").remove(this.gcp);
    if (gcp!=null){ this.gcp= new io.fabric8.openshift.api.model.GCPPlatformSpecBuilder(gcp); _visitables.get("gcp").add(this.gcp);} return (A) this;
  }
  public java.lang.Boolean hasGcp() {
    return this.gcp != null;
  }
  public PlatformSpecFluent.GcpNested<A> withNewGcp() {
    return new PlatformSpecFluentImpl.GcpNestedImpl();
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.GcpNested<A> withNewGcpLike(io.fabric8.openshift.api.model.GCPPlatformSpec item) {
    return new io.fabric8.openshift.api.model.PlatformSpecFluentImpl.GcpNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.GcpNested<A> editGcp() {
    return withNewGcpLike(getGcp());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.GcpNested<A> editOrNewGcp() {
    return withNewGcpLike(getGcp() != null ? getGcp(): new io.fabric8.openshift.api.model.GCPPlatformSpecBuilder().build());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.GcpNested<A> editOrNewGcpLike(io.fabric8.openshift.api.model.GCPPlatformSpec item) {
    return withNewGcpLike(getGcp() != null ? getGcp(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildIbmcloud instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.IBMCloudPlatformSpec getIbmcloud() {
    return this.ibmcloud!=null ?this.ibmcloud.build():null;
  }
  public io.fabric8.openshift.api.model.IBMCloudPlatformSpec buildIbmcloud() {
    return this.ibmcloud!=null ?this.ibmcloud.build():null;
  }
  public A withIbmcloud(io.fabric8.openshift.api.model.IBMCloudPlatformSpec ibmcloud) {
    _visitables.get("ibmcloud").remove(this.ibmcloud);
    if (ibmcloud!=null){ this.ibmcloud= new IBMCloudPlatformSpecBuilder(ibmcloud); _visitables.get("ibmcloud").add(this.ibmcloud);} return (A) this;
  }
  public java.lang.Boolean hasIbmcloud() {
    return this.ibmcloud != null;
  }
  public PlatformSpecFluent.IbmcloudNested<A> withNewIbmcloud() {
    return new PlatformSpecFluentImpl.IbmcloudNestedImpl();
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.IbmcloudNested<A> withNewIbmcloudLike(io.fabric8.openshift.api.model.IBMCloudPlatformSpec item) {
    return new io.fabric8.openshift.api.model.PlatformSpecFluentImpl.IbmcloudNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.IbmcloudNested<A> editIbmcloud() {
    return withNewIbmcloudLike(getIbmcloud());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.IbmcloudNested<A> editOrNewIbmcloud() {
    return withNewIbmcloudLike(getIbmcloud() != null ? getIbmcloud(): new io.fabric8.openshift.api.model.IBMCloudPlatformSpecBuilder().build());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.IbmcloudNested<A> editOrNewIbmcloudLike(io.fabric8.openshift.api.model.IBMCloudPlatformSpec item) {
    return withNewIbmcloudLike(getIbmcloud() != null ? getIbmcloud(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildKubevirt instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public KubevirtPlatformSpec getKubevirt() {
    return this.kubevirt!=null ?this.kubevirt.build():null;
  }
  public io.fabric8.openshift.api.model.KubevirtPlatformSpec buildKubevirt() {
    return this.kubevirt!=null ?this.kubevirt.build():null;
  }
  public A withKubevirt(io.fabric8.openshift.api.model.KubevirtPlatformSpec kubevirt) {
    _visitables.get("kubevirt").remove(this.kubevirt);
    if (kubevirt!=null){ this.kubevirt= new io.fabric8.openshift.api.model.KubevirtPlatformSpecBuilder(kubevirt); _visitables.get("kubevirt").add(this.kubevirt);} return (A) this;
  }
  public java.lang.Boolean hasKubevirt() {
    return this.kubevirt != null;
  }
  public PlatformSpecFluent.KubevirtNested<A> withNewKubevirt() {
    return new PlatformSpecFluentImpl.KubevirtNestedImpl();
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.KubevirtNested<A> withNewKubevirtLike(io.fabric8.openshift.api.model.KubevirtPlatformSpec item) {
    return new io.fabric8.openshift.api.model.PlatformSpecFluentImpl.KubevirtNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.KubevirtNested<A> editKubevirt() {
    return withNewKubevirtLike(getKubevirt());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.KubevirtNested<A> editOrNewKubevirt() {
    return withNewKubevirtLike(getKubevirt() != null ? getKubevirt(): new io.fabric8.openshift.api.model.KubevirtPlatformSpecBuilder().build());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.KubevirtNested<A> editOrNewKubevirtLike(io.fabric8.openshift.api.model.KubevirtPlatformSpec item) {
    return withNewKubevirtLike(getKubevirt() != null ? getKubevirt(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildOpenstack instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public OpenStackPlatformSpec getOpenstack() {
    return this.openstack!=null ?this.openstack.build():null;
  }
  public io.fabric8.openshift.api.model.OpenStackPlatformSpec buildOpenstack() {
    return this.openstack!=null ?this.openstack.build():null;
  }
  public A withOpenstack(io.fabric8.openshift.api.model.OpenStackPlatformSpec openstack) {
    _visitables.get("openstack").remove(this.openstack);
    if (openstack!=null){ this.openstack= new io.fabric8.openshift.api.model.OpenStackPlatformSpecBuilder(openstack); _visitables.get("openstack").add(this.openstack);} return (A) this;
  }
  public java.lang.Boolean hasOpenstack() {
    return this.openstack != null;
  }
  public PlatformSpecFluent.OpenstackNested<A> withNewOpenstack() {
    return new PlatformSpecFluentImpl.OpenstackNestedImpl();
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.OpenstackNested<A> withNewOpenstackLike(io.fabric8.openshift.api.model.OpenStackPlatformSpec item) {
    return new io.fabric8.openshift.api.model.PlatformSpecFluentImpl.OpenstackNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.OpenstackNested<A> editOpenstack() {
    return withNewOpenstackLike(getOpenstack());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.OpenstackNested<A> editOrNewOpenstack() {
    return withNewOpenstackLike(getOpenstack() != null ? getOpenstack(): new io.fabric8.openshift.api.model.OpenStackPlatformSpecBuilder().build());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.OpenstackNested<A> editOrNewOpenstackLike(io.fabric8.openshift.api.model.OpenStackPlatformSpec item) {
    return withNewOpenstackLike(getOpenstack() != null ? getOpenstack(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildOvirt instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public OvirtPlatformSpec getOvirt() {
    return this.ovirt!=null ?this.ovirt.build():null;
  }
  public io.fabric8.openshift.api.model.OvirtPlatformSpec buildOvirt() {
    return this.ovirt!=null ?this.ovirt.build():null;
  }
  public A withOvirt(io.fabric8.openshift.api.model.OvirtPlatformSpec ovirt) {
    _visitables.get("ovirt").remove(this.ovirt);
    if (ovirt!=null){ this.ovirt= new io.fabric8.openshift.api.model.OvirtPlatformSpecBuilder(ovirt); _visitables.get("ovirt").add(this.ovirt);} return (A) this;
  }
  public java.lang.Boolean hasOvirt() {
    return this.ovirt != null;
  }
  public PlatformSpecFluent.OvirtNested<A> withNewOvirt() {
    return new PlatformSpecFluentImpl.OvirtNestedImpl();
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.OvirtNested<A> withNewOvirtLike(io.fabric8.openshift.api.model.OvirtPlatformSpec item) {
    return new io.fabric8.openshift.api.model.PlatformSpecFluentImpl.OvirtNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.OvirtNested<A> editOvirt() {
    return withNewOvirtLike(getOvirt());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.OvirtNested<A> editOrNewOvirt() {
    return withNewOvirtLike(getOvirt() != null ? getOvirt(): new io.fabric8.openshift.api.model.OvirtPlatformSpecBuilder().build());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.OvirtNested<A> editOrNewOvirtLike(io.fabric8.openshift.api.model.OvirtPlatformSpec item) {
    return withNewOvirtLike(getOvirt() != null ? getOvirt(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPowervs instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public PowerVSPlatformSpec getPowervs() {
    return this.powervs!=null ?this.powervs.build():null;
  }
  public io.fabric8.openshift.api.model.PowerVSPlatformSpec buildPowervs() {
    return this.powervs!=null ?this.powervs.build():null;
  }
  public A withPowervs(io.fabric8.openshift.api.model.PowerVSPlatformSpec powervs) {
    _visitables.get("powervs").remove(this.powervs);
    if (powervs!=null){ this.powervs= new io.fabric8.openshift.api.model.PowerVSPlatformSpecBuilder(powervs); _visitables.get("powervs").add(this.powervs);} return (A) this;
  }
  public java.lang.Boolean hasPowervs() {
    return this.powervs != null;
  }
  public PlatformSpecFluent.PowervsNested<A> withNewPowervs() {
    return new PlatformSpecFluentImpl.PowervsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.PowervsNested<A> withNewPowervsLike(io.fabric8.openshift.api.model.PowerVSPlatformSpec item) {
    return new io.fabric8.openshift.api.model.PlatformSpecFluentImpl.PowervsNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.PowervsNested<A> editPowervs() {
    return withNewPowervsLike(getPowervs());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.PowervsNested<A> editOrNewPowervs() {
    return withNewPowervsLike(getPowervs() != null ? getPowervs(): new io.fabric8.openshift.api.model.PowerVSPlatformSpecBuilder().build());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.PowervsNested<A> editOrNewPowervsLike(io.fabric8.openshift.api.model.PowerVSPlatformSpec item) {
    return withNewPowervsLike(getPowervs() != null ? getPowervs(): item);
  }
  public java.lang.String getType() {
    return this.type;
  }
  public A withType(java.lang.String type) {
    this.type=type; return (A) this;
  }
  public java.lang.Boolean hasType() {
    return this.type != null;
  }
  
  /**
   * This method has been deprecated, please use method buildVsphere instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.VSpherePlatformSpec getVsphere() {
    return this.vsphere!=null ?this.vsphere.build():null;
  }
  public io.fabric8.openshift.api.model.VSpherePlatformSpec buildVsphere() {
    return this.vsphere!=null ?this.vsphere.build():null;
  }
  public A withVsphere(io.fabric8.openshift.api.model.VSpherePlatformSpec vsphere) {
    _visitables.get("vsphere").remove(this.vsphere);
    if (vsphere!=null){ this.vsphere= new VSpherePlatformSpecBuilder(vsphere); _visitables.get("vsphere").add(this.vsphere);} return (A) this;
  }
  public java.lang.Boolean hasVsphere() {
    return this.vsphere != null;
  }
  public PlatformSpecFluent.VsphereNested<A> withNewVsphere() {
    return new PlatformSpecFluentImpl.VsphereNestedImpl();
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.VsphereNested<A> withNewVsphereLike(io.fabric8.openshift.api.model.VSpherePlatformSpec item) {
    return new io.fabric8.openshift.api.model.PlatformSpecFluentImpl.VsphereNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.VsphereNested<A> editVsphere() {
    return withNewVsphereLike(getVsphere());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.VsphereNested<A> editOrNewVsphere() {
    return withNewVsphereLike(getVsphere() != null ? getVsphere(): new io.fabric8.openshift.api.model.VSpherePlatformSpecBuilder().build());
  }
  public io.fabric8.openshift.api.model.PlatformSpecFluent.VsphereNested<A> editOrNewVsphereLike(io.fabric8.openshift.api.model.VSpherePlatformSpec item) {
    return withNewVsphereLike(getVsphere() != null ? getVsphere(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PlatformSpecFluentImpl that = (PlatformSpecFluentImpl) o;
    if (alibabaCloud != null ? !alibabaCloud.equals(that.alibabaCloud) :that.alibabaCloud != null) return false;
    if (aws != null ? !aws.equals(that.aws) :that.aws != null) return false;
    if (azure != null ? !azure.equals(that.azure) :that.azure != null) return false;
    if (baremetal != null ? !baremetal.equals(that.baremetal) :that.baremetal != null) return false;
    if (equinixMetal != null ? !equinixMetal.equals(that.equinixMetal) :that.equinixMetal != null) return false;
    if (gcp != null ? !gcp.equals(that.gcp) :that.gcp != null) return false;
    if (ibmcloud != null ? !ibmcloud.equals(that.ibmcloud) :that.ibmcloud != null) return false;
    if (kubevirt != null ? !kubevirt.equals(that.kubevirt) :that.kubevirt != null) return false;
    if (openstack != null ? !openstack.equals(that.openstack) :that.openstack != null) return false;
    if (ovirt != null ? !ovirt.equals(that.ovirt) :that.ovirt != null) return false;
    if (powervs != null ? !powervs.equals(that.powervs) :that.powervs != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    if (vsphere != null ? !vsphere.equals(that.vsphere) :that.vsphere != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(alibabaCloud,  aws,  azure,  baremetal,  equinixMetal,  gcp,  ibmcloud,  kubevirt,  openstack,  ovirt,  powervs,  type,  vsphere,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (alibabaCloud != null) { sb.append("alibabaCloud:"); sb.append(alibabaCloud + ","); }
    if (aws != null) { sb.append("aws:"); sb.append(aws + ","); }
    if (azure != null) { sb.append("azure:"); sb.append(azure + ","); }
    if (baremetal != null) { sb.append("baremetal:"); sb.append(baremetal + ","); }
    if (equinixMetal != null) { sb.append("equinixMetal:"); sb.append(equinixMetal + ","); }
    if (gcp != null) { sb.append("gcp:"); sb.append(gcp + ","); }
    if (ibmcloud != null) { sb.append("ibmcloud:"); sb.append(ibmcloud + ","); }
    if (kubevirt != null) { sb.append("kubevirt:"); sb.append(kubevirt + ","); }
    if (openstack != null) { sb.append("openstack:"); sb.append(openstack + ","); }
    if (ovirt != null) { sb.append("ovirt:"); sb.append(ovirt + ","); }
    if (powervs != null) { sb.append("powervs:"); sb.append(powervs + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (vsphere != null) { sb.append("vsphere:"); sb.append(vsphere + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AlibabaCloudNestedImpl<N> extends AlibabaCloudPlatformSpecFluentImpl<PlatformSpecFluent.AlibabaCloudNested<N>> implements io.fabric8.openshift.api.model.PlatformSpecFluent.AlibabaCloudNested<N>,Nested<N>{
    AlibabaCloudNestedImpl(AlibabaCloudPlatformSpec item) {
      this.builder = new AlibabaCloudPlatformSpecBuilder(this, item);
    }
    AlibabaCloudNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.AlibabaCloudPlatformSpecBuilder(this);
    }
    io.fabric8.openshift.api.model.AlibabaCloudPlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withAlibabaCloud(builder.build());
    }
    public N endAlibabaCloud() {
      return and();
    }
    
  }
  class AwsNestedImpl<N> extends AWSPlatformSpecFluentImpl<PlatformSpecFluent.AwsNested<N>> implements io.fabric8.openshift.api.model.PlatformSpecFluent.AwsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AwsNestedImpl(AWSPlatformSpec item) {
      this.builder = new AWSPlatformSpecBuilder(this, item);
    }
    AwsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.AWSPlatformSpecBuilder(this);
    }
    io.fabric8.openshift.api.model.AWSPlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withAws(builder.build());
    }
    public N endAws() {
      return and();
    }
    
  }
  class AzureNestedImpl<N> extends AzurePlatformSpecFluentImpl<PlatformSpecFluent.AzureNested<N>> implements io.fabric8.openshift.api.model.PlatformSpecFluent.AzureNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AzureNestedImpl(AzurePlatformSpec item) {
      this.builder = new AzurePlatformSpecBuilder(this, item);
    }
    AzureNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.AzurePlatformSpecBuilder(this);
    }
    io.fabric8.openshift.api.model.AzurePlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withAzure(builder.build());
    }
    public N endAzure() {
      return and();
    }
    
  }
  class BaremetalNestedImpl<N> extends BareMetalPlatformSpecFluentImpl<PlatformSpecFluent.BaremetalNested<N>> implements io.fabric8.openshift.api.model.PlatformSpecFluent.BaremetalNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BaremetalNestedImpl(io.fabric8.openshift.api.model.BareMetalPlatformSpec item) {
      this.builder = new BareMetalPlatformSpecBuilder(this, item);
    }
    BaremetalNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.BareMetalPlatformSpecBuilder(this);
    }
    io.fabric8.openshift.api.model.BareMetalPlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withBaremetal(builder.build());
    }
    public N endBaremetal() {
      return and();
    }
    
  }
  class EquinixMetalNestedImpl<N> extends EquinixMetalPlatformSpecFluentImpl<PlatformSpecFluent.EquinixMetalNested<N>> implements io.fabric8.openshift.api.model.PlatformSpecFluent.EquinixMetalNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EquinixMetalNestedImpl(io.fabric8.openshift.api.model.EquinixMetalPlatformSpec item) {
      this.builder = new EquinixMetalPlatformSpecBuilder(this, item);
    }
    EquinixMetalNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.EquinixMetalPlatformSpecBuilder(this);
    }
    io.fabric8.openshift.api.model.EquinixMetalPlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withEquinixMetal(builder.build());
    }
    public N endEquinixMetal() {
      return and();
    }
    
  }
  class GcpNestedImpl<N> extends GCPPlatformSpecFluentImpl<PlatformSpecFluent.GcpNested<N>> implements io.fabric8.openshift.api.model.PlatformSpecFluent.GcpNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GcpNestedImpl(GCPPlatformSpec item) {
      this.builder = new GCPPlatformSpecBuilder(this, item);
    }
    GcpNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.GCPPlatformSpecBuilder(this);
    }
    io.fabric8.openshift.api.model.GCPPlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withGcp(builder.build());
    }
    public N endGcp() {
      return and();
    }
    
  }
  class IbmcloudNestedImpl<N> extends IBMCloudPlatformSpecFluentImpl<PlatformSpecFluent.IbmcloudNested<N>> implements io.fabric8.openshift.api.model.PlatformSpecFluent.IbmcloudNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    IbmcloudNestedImpl(IBMCloudPlatformSpec item) {
      this.builder = new IBMCloudPlatformSpecBuilder(this, item);
    }
    IbmcloudNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.IBMCloudPlatformSpecBuilder(this);
    }
    io.fabric8.openshift.api.model.IBMCloudPlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withIbmcloud(builder.build());
    }
    public N endIbmcloud() {
      return and();
    }
    
  }
  class KubevirtNestedImpl<N> extends KubevirtPlatformSpecFluentImpl<PlatformSpecFluent.KubevirtNested<N>> implements io.fabric8.openshift.api.model.PlatformSpecFluent.KubevirtNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    KubevirtNestedImpl(io.fabric8.openshift.api.model.KubevirtPlatformSpec item) {
      this.builder = new KubevirtPlatformSpecBuilder(this, item);
    }
    KubevirtNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.KubevirtPlatformSpecBuilder(this);
    }
    io.fabric8.openshift.api.model.KubevirtPlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withKubevirt(builder.build());
    }
    public N endKubevirt() {
      return and();
    }
    
  }
  class OpenstackNestedImpl<N> extends OpenStackPlatformSpecFluentImpl<PlatformSpecFluent.OpenstackNested<N>> implements io.fabric8.openshift.api.model.PlatformSpecFluent.OpenstackNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OpenstackNestedImpl(OpenStackPlatformSpec item) {
      this.builder = new OpenStackPlatformSpecBuilder(this, item);
    }
    OpenstackNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OpenStackPlatformSpecBuilder(this);
    }
    io.fabric8.openshift.api.model.OpenStackPlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withOpenstack(builder.build());
    }
    public N endOpenstack() {
      return and();
    }
    
  }
  class OvirtNestedImpl<N> extends OvirtPlatformSpecFluentImpl<PlatformSpecFluent.OvirtNested<N>> implements io.fabric8.openshift.api.model.PlatformSpecFluent.OvirtNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OvirtNestedImpl(OvirtPlatformSpec item) {
      this.builder = new OvirtPlatformSpecBuilder(this, item);
    }
    OvirtNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OvirtPlatformSpecBuilder(this);
    }
    io.fabric8.openshift.api.model.OvirtPlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withOvirt(builder.build());
    }
    public N endOvirt() {
      return and();
    }
    
  }
  class PowervsNestedImpl<N> extends PowerVSPlatformSpecFluentImpl<PlatformSpecFluent.PowervsNested<N>> implements io.fabric8.openshift.api.model.PlatformSpecFluent.PowervsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PowervsNestedImpl(io.fabric8.openshift.api.model.PowerVSPlatformSpec item) {
      this.builder = new PowerVSPlatformSpecBuilder(this, item);
    }
    PowervsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.PowerVSPlatformSpecBuilder(this);
    }
    io.fabric8.openshift.api.model.PowerVSPlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withPowervs(builder.build());
    }
    public N endPowervs() {
      return and();
    }
    
  }
  class VsphereNestedImpl<N> extends VSpherePlatformSpecFluentImpl<PlatformSpecFluent.VsphereNested<N>> implements io.fabric8.openshift.api.model.PlatformSpecFluent.VsphereNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    VsphereNestedImpl(io.fabric8.openshift.api.model.VSpherePlatformSpec item) {
      this.builder = new VSpherePlatformSpecBuilder(this, item);
    }
    VsphereNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.VSpherePlatformSpecBuilder(this);
    }
    io.fabric8.openshift.api.model.VSpherePlatformSpecBuilder builder;
    public N and() {
      return (N) PlatformSpecFluentImpl.this.withVsphere(builder.build());
    }
    public N endVsphere() {
      return and();
    }
    
  }
  
}