package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlatformStatusBuilder extends PlatformStatusFluentImpl<PlatformStatusBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.PlatformStatus,io.fabric8.openshift.api.model.PlatformStatusBuilder>{
  public PlatformStatusBuilder() {
    this(false);
  }
  public PlatformStatusBuilder(Boolean validationEnabled) {
    this(new PlatformStatus(), validationEnabled);
  }
  public PlatformStatusBuilder(PlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformStatusBuilder(io.fabric8.openshift.api.model.PlatformStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PlatformStatus(), validationEnabled);
  }
  public PlatformStatusBuilder(io.fabric8.openshift.api.model.PlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.PlatformStatus instance) {
    this(fluent, instance, false);
  }
  public PlatformStatusBuilder(io.fabric8.openshift.api.model.PlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.PlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAlibabaCloud(instance.getAlibabaCloud()); 
    fluent.withAws(instance.getAws()); 
    fluent.withAzure(instance.getAzure()); 
    fluent.withBaremetal(instance.getBaremetal()); 
    fluent.withEquinixMetal(instance.getEquinixMetal()); 
    fluent.withGcp(instance.getGcp()); 
    fluent.withIbmcloud(instance.getIbmcloud()); 
    fluent.withKubevirt(instance.getKubevirt()); 
    fluent.withOpenstack(instance.getOpenstack()); 
    fluent.withOvirt(instance.getOvirt()); 
    fluent.withPowervs(instance.getPowervs()); 
    fluent.withType(instance.getType()); 
    fluent.withVsphere(instance.getVsphere()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PlatformStatusBuilder(io.fabric8.openshift.api.model.PlatformStatus instance) {
    this(instance,false);
  }
  public PlatformStatusBuilder(io.fabric8.openshift.api.model.PlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAlibabaCloud(instance.getAlibabaCloud()); 
    this.withAws(instance.getAws()); 
    this.withAzure(instance.getAzure()); 
    this.withBaremetal(instance.getBaremetal()); 
    this.withEquinixMetal(instance.getEquinixMetal()); 
    this.withGcp(instance.getGcp()); 
    this.withIbmcloud(instance.getIbmcloud()); 
    this.withKubevirt(instance.getKubevirt()); 
    this.withOpenstack(instance.getOpenstack()); 
    this.withOvirt(instance.getOvirt()); 
    this.withPowervs(instance.getPowervs()); 
    this.withType(instance.getType()); 
    this.withVsphere(instance.getVsphere()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.PlatformStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.PlatformStatus build() {
    PlatformStatus buildable = new PlatformStatus(fluent.getAlibabaCloud(),fluent.getAws(),fluent.getAzure(),fluent.getBaremetal(),fluent.getEquinixMetal(),fluent.getGcp(),fluent.getIbmcloud(),fluent.getKubevirt(),fluent.getOpenstack(),fluent.getOvirt(),fluent.getPowervs(),fluent.getType(),fluent.getVsphere());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}