package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Deprecated;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PolicyRuleFluentImpl<A extends PolicyRuleFluent<A>> extends BaseFluent<A> implements PolicyRuleFluent<A>{
  public PolicyRuleFluentImpl() {
  }
  public PolicyRuleFluentImpl(io.fabric8.openshift.api.model.PolicyRule instance) {
    this.withApiGroups(instance.getApiGroups()); 
    this.withAttributeRestrictions(instance.getAttributeRestrictions()); 
    this.withNonResourceURLs(instance.getNonResourceURLs()); 
    this.withResourceNames(instance.getResourceNames()); 
    this.withResources(instance.getResources()); 
    this.withVerbs(instance.getVerbs()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> apiGroups = new ArrayList<java.lang.String>();
  private VisitableBuilder<? extends HasMetadata,?> attributeRestrictions;
  private java.util.List<java.lang.String> nonResourceURLs = new java.util.ArrayList<java.lang.String>();
  private java.util.List<java.lang.String> resourceNames = new java.util.ArrayList<java.lang.String>();
  private java.util.List<java.lang.String> resources = new java.util.ArrayList<java.lang.String>();
  private java.util.List<java.lang.String> verbs = new java.util.ArrayList<java.lang.String>();
  private Map<java.lang.String,Object> additionalProperties;
  public A addToApiGroups(Integer index,java.lang.String item) {
    if (this.apiGroups == null) {this.apiGroups = new java.util.ArrayList<java.lang.String>();}
    this.apiGroups.add(index, item);
    return (A)this;
  }
  public A setToApiGroups(java.lang.Integer index,java.lang.String item) {
    if (this.apiGroups == null) {this.apiGroups = new java.util.ArrayList<java.lang.String>();}
    this.apiGroups.set(index, item); return (A)this;
  }
  public A addToApiGroups(java.lang.String... items) {
    if (this.apiGroups == null) {this.apiGroups = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.apiGroups.add(item);} return (A)this;
  }
  public A addAllToApiGroups(Collection<java.lang.String> items) {
    if (this.apiGroups == null) {this.apiGroups = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.apiGroups.add(item);} return (A)this;
  }
  public A removeFromApiGroups(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.apiGroups!= null){ this.apiGroups.remove(item);}} return (A)this;
  }
  public A removeAllFromApiGroups(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.apiGroups!= null){ this.apiGroups.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getApiGroups() {
    return this.apiGroups;
  }
  public java.lang.String getApiGroup(java.lang.Integer index) {
    return this.apiGroups.get(index);
  }
  public java.lang.String getFirstApiGroup() {
    return this.apiGroups.get(0);
  }
  public java.lang.String getLastApiGroup() {
    return this.apiGroups.get(apiGroups.size() - 1);
  }
  public java.lang.String getMatchingApiGroup(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: apiGroups) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingApiGroup(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: apiGroups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withApiGroups(java.util.List<java.lang.String> apiGroups) {
    if (apiGroups != null) {this.apiGroups = new java.util.ArrayList(); for (java.lang.String item : apiGroups){this.addToApiGroups(item);}} else { this.apiGroups = null;} return (A) this;
  }
  public A withApiGroups(java.lang.String... apiGroups) {
    if (this.apiGroups != null) {this.apiGroups.clear();}
    if (apiGroups != null) {for (java.lang.String item :apiGroups){ this.addToApiGroups(item);}} return (A) this;
  }
  public java.lang.Boolean hasApiGroups() {
    return apiGroups != null && !apiGroups.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildAttributeRestrictions instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.kubernetes.api.model.HasMetadata getAttributeRestrictions() {
    return this.attributeRestrictions!=null?this.attributeRestrictions.build():null;
  }
  public io.fabric8.kubernetes.api.model.HasMetadata buildAttributeRestrictions() {
    return this.attributeRestrictions!=null?this.attributeRestrictions.build():null;
  }
  public A withAttributeRestrictions(io.fabric8.kubernetes.api.model.HasMetadata attributeRestrictions) {
    if (attributeRestrictions instanceof ClusterVersion){ this.attributeRestrictions= new ClusterVersionBuilder((io.fabric8.openshift.api.model.ClusterVersion)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DNS){ this.attributeRestrictions= new DNSBuilder((io.fabric8.openshift.api.model.DNS)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamImport){ this.attributeRestrictions= new ImageStreamImportBuilder((ImageStreamImport)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Proxy){ this.attributeRestrictions= new ProxyBuilder((io.fabric8.openshift.api.model.Proxy)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Project){ this.attributeRestrictions= new ProjectBuilder((io.fabric8.openshift.api.model.Project)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterOperator){ this.attributeRestrictions= new ClusterOperatorBuilder((io.fabric8.openshift.api.model.ClusterOperator)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildConfig){ this.attributeRestrictions= new BuildConfigBuilder((BuildConfig)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof HelmChartRepository){ this.attributeRestrictions= new HelmChartRepositoryBuilder((io.fabric8.openshift.api.model.HelmChartRepository)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Infrastructure){ this.attributeRestrictions= new InfrastructureBuilder((io.fabric8.openshift.api.model.Infrastructure)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Scheduler){ this.attributeRestrictions= new SchedulerBuilder((io.fabric8.openshift.api.model.Scheduler)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RangeAllocation){ this.attributeRestrictions= new RangeAllocationBuilder((io.fabric8.openshift.api.model.RangeAllocation)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Route){ this.attributeRestrictions= new RouteBuilder((io.fabric8.openshift.api.model.Route)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterNetwork){ this.attributeRestrictions= new ClusterNetworkBuilder((io.fabric8.openshift.api.model.ClusterNetwork)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthAuthorizeToken){ this.attributeRestrictions= new OAuthAuthorizeTokenBuilder((OAuthAuthorizeToken)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof UserOAuthAccessToken){ this.attributeRestrictions= new UserOAuthAccessTokenBuilder((UserOAuthAccessToken)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Ingress){ this.attributeRestrictions= new IngressBuilder((io.fabric8.openshift.api.model.Ingress)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof io.fabric8.openshift.api.model.OAuth){ this.attributeRestrictions= new OAuthBuilder((io.fabric8.openshift.api.model.OAuth)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OperatorHub){ this.attributeRestrictions= new OperatorHubBuilder((io.fabric8.openshift.api.model.OperatorHub)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterRoleBinding){ this.attributeRestrictions= new ClusterRoleBindingBuilder((io.fabric8.openshift.api.model.ClusterRoleBinding)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterResourceQuota){ this.attributeRestrictions= new ClusterResourceQuotaBuilder((io.fabric8.openshift.api.model.ClusterResourceQuota)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ProjectRequest){ this.attributeRestrictions= new ProjectRequestBuilder((io.fabric8.openshift.api.model.ProjectRequest)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Template){ this.attributeRestrictions= new TemplateBuilder((io.fabric8.openshift.api.model.Template)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthClientAuthorization){ this.attributeRestrictions= new OAuthClientAuthorizationBuilder((OAuthClientAuthorization)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof io.fabric8.openshift.api.model.ClusterRole){ this.attributeRestrictions= new ClusterRoleBuilder((io.fabric8.openshift.api.model.ClusterRole)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Authentication){ this.attributeRestrictions= new AuthenticationBuilder((io.fabric8.openshift.api.model.Authentication)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageTag){ this.attributeRestrictions= new ImageTagBuilder((io.fabric8.openshift.api.model.ImageTag)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthAccessToken){ this.attributeRestrictions= new OAuthAccessTokenBuilder((io.fabric8.openshift.api.model.OAuthAccessToken)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentConfig){ this.attributeRestrictions= new DeploymentConfigBuilder((io.fabric8.openshift.api.model.DeploymentConfig)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RoleBinding){ this.attributeRestrictions= new RoleBindingBuilder((io.fabric8.openshift.api.model.RoleBinding)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof io.fabric8.openshift.api.model.Image){ this.attributeRestrictions= new ImageBuilder((io.fabric8.openshift.api.model.Image)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof APIServer){ this.attributeRestrictions= new APIServerBuilder((io.fabric8.openshift.api.model.APIServer)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PersistentVolumeClaim){ this.attributeRestrictions= new PersistentVolumeClaimBuilder((io.fabric8.kubernetes.api.model.PersistentVolumeClaim)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamMapping){ this.attributeRestrictions= new ImageStreamMappingBuilder((io.fabric8.openshift.api.model.ImageStreamMapping)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof io.fabric8.openshift.api.model.Role){ this.attributeRestrictions= new RoleBuilder((io.fabric8.openshift.api.model.Role)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BrokerTemplateInstance){ this.attributeRestrictions= new BrokerTemplateInstanceBuilder((io.fabric8.openshift.api.model.BrokerTemplateInstance)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof FeatureGate){ this.attributeRestrictions= new FeatureGateBuilder((io.fabric8.openshift.api.model.FeatureGate)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof io.fabric8.openshift.api.model.User){ this.attributeRestrictions= new UserBuilder((io.fabric8.openshift.api.model.User)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamImage){ this.attributeRestrictions= new ImageStreamImageBuilder((io.fabric8.openshift.api.model.ImageStreamImage)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TemplateInstance){ this.attributeRestrictions= new TemplateInstanceBuilder((io.fabric8.openshift.api.model.TemplateInstance)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof io.fabric8.openshift.api.model.Build){ this.attributeRestrictions= new BuildBuilder((io.fabric8.openshift.api.model.Build)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RoleBindingRestriction){ this.attributeRestrictions= new RoleBindingRestrictionBuilder((io.fabric8.openshift.api.model.RoleBindingRestriction)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamTag){ this.attributeRestrictions= new ImageStreamTagBuilder((io.fabric8.openshift.api.model.ImageStreamTag)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Group){ this.attributeRestrictions= new GroupBuilder((io.fabric8.openshift.api.model.Group)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageSignature){ this.attributeRestrictions= new ImageSignatureBuilder((io.fabric8.openshift.api.model.ImageSignature)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof HostSubnet){ this.attributeRestrictions= new HostSubnetBuilder((io.fabric8.openshift.api.model.HostSubnet)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof AppliedClusterResourceQuota){ this.attributeRestrictions= new AppliedClusterResourceQuotaBuilder((io.fabric8.openshift.api.model.AppliedClusterResourceQuota)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SecurityContextConstraints){ this.attributeRestrictions= new SecurityContextConstraintsBuilder((io.fabric8.openshift.api.model.SecurityContextConstraints)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Console){ this.attributeRestrictions= new ConsoleBuilder((io.fabric8.openshift.api.model.Console)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildRequest){ this.attributeRestrictions= new BuildRequestBuilder((io.fabric8.openshift.api.model.BuildRequest)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof EgressNetworkPolicy){ this.attributeRestrictions= new EgressNetworkPolicyBuilder((io.fabric8.openshift.api.model.EgressNetworkPolicy)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof NetNamespace){ this.attributeRestrictions= new NetNamespaceBuilder((io.fabric8.openshift.api.model.NetNamespace)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof UserIdentityMapping){ this.attributeRestrictions= new UserIdentityMappingBuilder((io.fabric8.openshift.api.model.UserIdentityMapping)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof io.fabric8.openshift.api.model.ImageStream){ this.attributeRestrictions= new ImageStreamBuilder((io.fabric8.openshift.api.model.ImageStream)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Network){ this.attributeRestrictions= new NetworkBuilder((io.fabric8.openshift.api.model.Network)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof io.fabric8.openshift.api.model.OAuthClient){ this.attributeRestrictions= new OAuthClientBuilder((io.fabric8.openshift.api.model.OAuthClient)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Identity){ this.attributeRestrictions= new IdentityBuilder((io.fabric8.openshift.api.model.Identity)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    return (A) this;
  }
  public java.lang.Boolean hasAttributeRestrictions() {
    return this.attributeRestrictions != null;
  }
  public A withClusterVersionAttributeRestrictions(io.fabric8.openshift.api.model.ClusterVersion clusterVersionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterVersionAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.ClusterVersionBuilder(clusterVersionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.ClusterVersionAttributeRestrictionsNested<A> withNewClusterVersionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterVersionAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterVersionAttributeRestrictionsNested<A> withNewClusterVersionAttributeRestrictionsLike(io.fabric8.openshift.api.model.ClusterVersion item) {
    return new PolicyRuleFluentImpl.ClusterVersionAttributeRestrictionsNestedImpl(item);
  }
  public A withDNSAttributeRestrictions(io.fabric8.openshift.api.model.DNS dNSAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (dNSAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.DNSBuilder(dNSAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.DNSAttributeRestrictionsNested<A> withNewDNSAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DNSAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.DNSAttributeRestrictionsNested<A> withNewDNSAttributeRestrictionsLike(io.fabric8.openshift.api.model.DNS item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.DNSAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamImportAttributeRestrictions(io.fabric8.openshift.api.model.ImageStreamImport imageStreamImportAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamImportAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamImportBuilder(imageStreamImportAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<A> withNewImageStreamImportAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamImportAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<A> withNewImageStreamImportAttributeRestrictionsLike(io.fabric8.openshift.api.model.ImageStreamImport item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.ImageStreamImportAttributeRestrictionsNestedImpl(item);
  }
  public A withProxyAttributeRestrictions(io.fabric8.openshift.api.model.Proxy proxyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (proxyAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.ProxyBuilder(proxyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.ProxyAttributeRestrictionsNested<A> withNewProxyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ProxyAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.ProxyAttributeRestrictionsNested<A> withNewProxyAttributeRestrictionsLike(io.fabric8.openshift.api.model.Proxy item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.ProxyAttributeRestrictionsNestedImpl(item);
  }
  public A withProjectAttributeRestrictions(io.fabric8.openshift.api.model.Project projectAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (projectAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.ProjectBuilder(projectAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.ProjectAttributeRestrictionsNested<A> withNewProjectAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ProjectAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.ProjectAttributeRestrictionsNested<A> withNewProjectAttributeRestrictionsLike(io.fabric8.openshift.api.model.Project item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.ProjectAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterOperatorAttributeRestrictions(io.fabric8.openshift.api.model.ClusterOperator clusterOperatorAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterOperatorAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.ClusterOperatorBuilder(clusterOperatorAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.ClusterOperatorAttributeRestrictionsNested<A> withNewClusterOperatorAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterOperatorAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterOperatorAttributeRestrictionsNested<A> withNewClusterOperatorAttributeRestrictionsLike(io.fabric8.openshift.api.model.ClusterOperator item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.ClusterOperatorAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildConfigAttributeRestrictions(io.fabric8.openshift.api.model.BuildConfig buildConfigAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildConfigAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.BuildConfigBuilder(buildConfigAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<A> withNewBuildConfigAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildConfigAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<A> withNewBuildConfigAttributeRestrictionsLike(io.fabric8.openshift.api.model.BuildConfig item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.BuildConfigAttributeRestrictionsNestedImpl(item);
  }
  public A withHelmChartRepositoryAttributeRestrictions(io.fabric8.openshift.api.model.HelmChartRepository helmChartRepositoryAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (helmChartRepositoryAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.HelmChartRepositoryBuilder(helmChartRepositoryAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.HelmChartRepositoryAttributeRestrictionsNested<A> withNewHelmChartRepositoryAttributeRestrictions() {
    return new PolicyRuleFluentImpl.HelmChartRepositoryAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.HelmChartRepositoryAttributeRestrictionsNested<A> withNewHelmChartRepositoryAttributeRestrictionsLike(io.fabric8.openshift.api.model.HelmChartRepository item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.HelmChartRepositoryAttributeRestrictionsNestedImpl(item);
  }
  public A withInfrastructureAttributeRestrictions(io.fabric8.openshift.api.model.Infrastructure infrastructureAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (infrastructureAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.InfrastructureBuilder(infrastructureAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.InfrastructureAttributeRestrictionsNested<A> withNewInfrastructureAttributeRestrictions() {
    return new PolicyRuleFluentImpl.InfrastructureAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.InfrastructureAttributeRestrictionsNested<A> withNewInfrastructureAttributeRestrictionsLike(io.fabric8.openshift.api.model.Infrastructure item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.InfrastructureAttributeRestrictionsNestedImpl(item);
  }
  public A withSchedulerAttributeRestrictions(io.fabric8.openshift.api.model.Scheduler schedulerAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (schedulerAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.SchedulerBuilder(schedulerAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.SchedulerAttributeRestrictionsNested<A> withNewSchedulerAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SchedulerAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.SchedulerAttributeRestrictionsNested<A> withNewSchedulerAttributeRestrictionsLike(io.fabric8.openshift.api.model.Scheduler item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.SchedulerAttributeRestrictionsNestedImpl(item);
  }
  public A withRangeAllocationAttributeRestrictions(io.fabric8.openshift.api.model.RangeAllocation rangeAllocationAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (rangeAllocationAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.RangeAllocationBuilder(rangeAllocationAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<A> withNewRangeAllocationAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RangeAllocationAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<A> withNewRangeAllocationAttributeRestrictionsLike(io.fabric8.openshift.api.model.RangeAllocation item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.RangeAllocationAttributeRestrictionsNestedImpl(item);
  }
  public A withRouteAttributeRestrictions(io.fabric8.openshift.api.model.Route routeAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (routeAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.RouteBuilder(routeAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.RouteAttributeRestrictionsNested<A> withNewRouteAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RouteAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.RouteAttributeRestrictionsNested<A> withNewRouteAttributeRestrictionsLike(io.fabric8.openshift.api.model.Route item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.RouteAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterNetworkAttributeRestrictions(io.fabric8.openshift.api.model.ClusterNetwork clusterNetworkAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterNetworkAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.ClusterNetworkBuilder(clusterNetworkAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<A> withNewClusterNetworkAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterNetworkAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<A> withNewClusterNetworkAttributeRestrictionsLike(io.fabric8.openshift.api.model.ClusterNetwork item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.ClusterNetworkAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthAuthorizeTokenAttributeRestrictions(io.fabric8.openshift.api.model.OAuthAuthorizeToken oAuthAuthorizeTokenAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthAuthorizeTokenAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder(oAuthAuthorizeTokenAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthAuthorizeTokenAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenAttributeRestrictionsLike(io.fabric8.openshift.api.model.OAuthAuthorizeToken item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.OAuthAuthorizeTokenAttributeRestrictionsNestedImpl(item);
  }
  public A withUserOAuthAccessTokenAttributeRestrictions(io.fabric8.openshift.api.model.UserOAuthAccessToken userOAuthAccessTokenAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (userOAuthAccessTokenAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder(userOAuthAccessTokenAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.UserOAuthAccessTokenAttributeRestrictionsNested<A> withNewUserOAuthAccessTokenAttributeRestrictions() {
    return new PolicyRuleFluentImpl.UserOAuthAccessTokenAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.UserOAuthAccessTokenAttributeRestrictionsNested<A> withNewUserOAuthAccessTokenAttributeRestrictionsLike(io.fabric8.openshift.api.model.UserOAuthAccessToken item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.UserOAuthAccessTokenAttributeRestrictionsNestedImpl(item);
  }
  public A withIngressAttributeRestrictions(io.fabric8.openshift.api.model.Ingress ingressAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (ingressAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.IngressBuilder(ingressAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.IngressAttributeRestrictionsNested<A> withNewIngressAttributeRestrictions() {
    return new PolicyRuleFluentImpl.IngressAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.IngressAttributeRestrictionsNested<A> withNewIngressAttributeRestrictionsLike(io.fabric8.openshift.api.model.Ingress item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.IngressAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthAttributeRestrictions(io.fabric8.openshift.api.model.OAuth oAuthAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.OAuthBuilder(oAuthAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.OAuthAttributeRestrictionsNested<A> withNewOAuthAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthAttributeRestrictionsNested<A> withNewOAuthAttributeRestrictionsLike(io.fabric8.openshift.api.model.OAuth item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.OAuthAttributeRestrictionsNestedImpl(item);
  }
  public A withOperatorHubAttributeRestrictions(io.fabric8.openshift.api.model.OperatorHub operatorHubAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (operatorHubAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.OperatorHubBuilder(operatorHubAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.OperatorHubAttributeRestrictionsNested<A> withNewOperatorHubAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OperatorHubAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.OperatorHubAttributeRestrictionsNested<A> withNewOperatorHubAttributeRestrictionsLike(io.fabric8.openshift.api.model.OperatorHub item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.OperatorHubAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterRoleBindingAttributeRestrictions(io.fabric8.openshift.api.model.ClusterRoleBinding clusterRoleBindingAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterRoleBindingAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterRoleBindingBuilder(clusterRoleBindingAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<A> withNewClusterRoleBindingAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterRoleBindingAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<A> withNewClusterRoleBindingAttributeRestrictionsLike(io.fabric8.openshift.api.model.ClusterRoleBinding item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.ClusterRoleBindingAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterResourceQuotaAttributeRestrictions(io.fabric8.openshift.api.model.ClusterResourceQuota clusterResourceQuotaAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterResourceQuotaAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder(clusterResourceQuotaAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<A> withNewClusterResourceQuotaAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<A> withNewClusterResourceQuotaAttributeRestrictionsLike(io.fabric8.openshift.api.model.ClusterResourceQuota item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.ClusterResourceQuotaAttributeRestrictionsNestedImpl(item);
  }
  public A withProjectRequestAttributeRestrictions(io.fabric8.openshift.api.model.ProjectRequest projectRequestAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (projectRequestAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.ProjectRequestBuilder(projectRequestAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<A> withNewProjectRequestAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ProjectRequestAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<A> withNewProjectRequestAttributeRestrictionsLike(io.fabric8.openshift.api.model.ProjectRequest item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.ProjectRequestAttributeRestrictionsNestedImpl(item);
  }
  public A withTemplateAttributeRestrictions(io.fabric8.openshift.api.model.Template templateAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.TemplateBuilder(templateAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.TemplateAttributeRestrictionsNested<A> withNewTemplateAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.TemplateAttributeRestrictionsNested<A> withNewTemplateAttributeRestrictionsLike(io.fabric8.openshift.api.model.Template item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.TemplateAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthClientAuthorizationAttributeRestrictions(io.fabric8.openshift.api.model.OAuthClientAuthorization oAuthClientAuthorizationAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthClientAuthorizationAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder(oAuthClientAuthorizationAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthClientAuthorizationAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationAttributeRestrictionsLike(io.fabric8.openshift.api.model.OAuthClientAuthorization item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.OAuthClientAuthorizationAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterRoleAttributeRestrictions(io.fabric8.openshift.api.model.ClusterRole clusterRoleAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterRoleAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.ClusterRoleBuilder(clusterRoleAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<A> withNewClusterRoleAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterRoleAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<A> withNewClusterRoleAttributeRestrictionsLike(io.fabric8.openshift.api.model.ClusterRole item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.ClusterRoleAttributeRestrictionsNestedImpl(item);
  }
  public A withAuthenticationAttributeRestrictions(io.fabric8.openshift.api.model.Authentication authenticationAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (authenticationAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.AuthenticationBuilder(authenticationAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.AuthenticationAttributeRestrictionsNested<A> withNewAuthenticationAttributeRestrictions() {
    return new PolicyRuleFluentImpl.AuthenticationAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.AuthenticationAttributeRestrictionsNested<A> withNewAuthenticationAttributeRestrictionsLike(io.fabric8.openshift.api.model.Authentication item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.AuthenticationAttributeRestrictionsNestedImpl(item);
  }
  public A withImageTagAttributeRestrictions(io.fabric8.openshift.api.model.ImageTag imageTagAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageTagAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.ImageTagBuilder(imageTagAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.ImageTagAttributeRestrictionsNested<A> withNewImageTagAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageTagAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageTagAttributeRestrictionsNested<A> withNewImageTagAttributeRestrictionsLike(io.fabric8.openshift.api.model.ImageTag item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.ImageTagAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthAccessTokenAttributeRestrictions(io.fabric8.openshift.api.model.OAuthAccessToken oAuthAccessTokenAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthAccessTokenAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.OAuthAccessTokenBuilder(oAuthAccessTokenAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<A> withNewOAuthAccessTokenAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthAccessTokenAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<A> withNewOAuthAccessTokenAttributeRestrictionsLike(io.fabric8.openshift.api.model.OAuthAccessToken item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.OAuthAccessTokenAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentConfigAttributeRestrictions(io.fabric8.openshift.api.model.DeploymentConfig deploymentConfigAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentConfigAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.DeploymentConfigBuilder(deploymentConfigAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<A> withNewDeploymentConfigAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentConfigAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<A> withNewDeploymentConfigAttributeRestrictionsLike(io.fabric8.openshift.api.model.DeploymentConfig item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.DeploymentConfigAttributeRestrictionsNestedImpl(item);
  }
  public A withRoleBindingAttributeRestrictions(io.fabric8.openshift.api.model.RoleBinding roleBindingAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (roleBindingAttributeRestrictions!=null){ this.attributeRestrictions= new RoleBindingBuilder(roleBindingAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<A> withNewRoleBindingAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoleBindingAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<A> withNewRoleBindingAttributeRestrictionsLike(io.fabric8.openshift.api.model.RoleBinding item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.RoleBindingAttributeRestrictionsNestedImpl(item);
  }
  public A withImageAttributeRestrictions(io.fabric8.openshift.api.model.Image imageAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.ImageBuilder(imageAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.ImageAttributeRestrictionsNested<A> withNewImageAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageAttributeRestrictionsNested<A> withNewImageAttributeRestrictionsLike(io.fabric8.openshift.api.model.Image item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.ImageAttributeRestrictionsNestedImpl(item);
  }
  public A withAPIServerAttributeRestrictions(io.fabric8.openshift.api.model.APIServer aPIServerAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (aPIServerAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.APIServerBuilder(aPIServerAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.APIServerAttributeRestrictionsNested<A> withNewAPIServerAttributeRestrictions() {
    return new PolicyRuleFluentImpl.APIServerAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.APIServerAttributeRestrictionsNested<A> withNewAPIServerAttributeRestrictionsLike(io.fabric8.openshift.api.model.APIServer item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.APIServerAttributeRestrictionsNestedImpl(item);
  }
  public A withPersistentVolumeClaimAttributeRestrictions(io.fabric8.kubernetes.api.model.PersistentVolumeClaim persistentVolumeClaimAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (persistentVolumeClaimAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(persistentVolumeClaimAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<A> withNewPersistentVolumeClaimAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PersistentVolumeClaimAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<A> withNewPersistentVolumeClaimAttributeRestrictionsLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.PersistentVolumeClaimAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamMappingAttributeRestrictions(io.fabric8.openshift.api.model.ImageStreamMapping imageStreamMappingAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamMappingAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.ImageStreamMappingBuilder(imageStreamMappingAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<A> withNewImageStreamMappingAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamMappingAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<A> withNewImageStreamMappingAttributeRestrictionsLike(io.fabric8.openshift.api.model.ImageStreamMapping item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.ImageStreamMappingAttributeRestrictionsNestedImpl(item);
  }
  public A withRoleAttributeRestrictions(io.fabric8.openshift.api.model.Role roleAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (roleAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.RoleBuilder(roleAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.RoleAttributeRestrictionsNested<A> withNewRoleAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoleAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.RoleAttributeRestrictionsNested<A> withNewRoleAttributeRestrictionsLike(io.fabric8.openshift.api.model.Role item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.RoleAttributeRestrictionsNestedImpl(item);
  }
  public A withBrokerTemplateInstanceAttributeRestrictions(io.fabric8.openshift.api.model.BrokerTemplateInstance brokerTemplateInstanceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (brokerTemplateInstanceAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder(brokerTemplateInstanceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.BrokerTemplateInstanceAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BrokerTemplateInstanceAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.BrokerTemplateInstanceAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceAttributeRestrictionsLike(io.fabric8.openshift.api.model.BrokerTemplateInstance item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.BrokerTemplateInstanceAttributeRestrictionsNestedImpl(item);
  }
  public A withFeatureGateAttributeRestrictions(io.fabric8.openshift.api.model.FeatureGate featureGateAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (featureGateAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.FeatureGateBuilder(featureGateAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.FeatureGateAttributeRestrictionsNested<A> withNewFeatureGateAttributeRestrictions() {
    return new PolicyRuleFluentImpl.FeatureGateAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.FeatureGateAttributeRestrictionsNested<A> withNewFeatureGateAttributeRestrictionsLike(io.fabric8.openshift.api.model.FeatureGate item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.FeatureGateAttributeRestrictionsNestedImpl(item);
  }
  public A withUserAttributeRestrictions(io.fabric8.openshift.api.model.User userAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (userAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.UserBuilder(userAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.UserAttributeRestrictionsNested<A> withNewUserAttributeRestrictions() {
    return new PolicyRuleFluentImpl.UserAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.UserAttributeRestrictionsNested<A> withNewUserAttributeRestrictionsLike(io.fabric8.openshift.api.model.User item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.UserAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamImageAttributeRestrictions(io.fabric8.openshift.api.model.ImageStreamImage imageStreamImageAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamImageAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.ImageStreamImageBuilder(imageStreamImageAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<A> withNewImageStreamImageAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamImageAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<A> withNewImageStreamImageAttributeRestrictionsLike(io.fabric8.openshift.api.model.ImageStreamImage item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.ImageStreamImageAttributeRestrictionsNestedImpl(item);
  }
  public A withTemplateInstanceAttributeRestrictions(io.fabric8.openshift.api.model.TemplateInstance templateInstanceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateInstanceAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.TemplateInstanceBuilder(templateInstanceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.TemplateInstanceAttributeRestrictionsNested<A> withNewTemplateInstanceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateInstanceAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.TemplateInstanceAttributeRestrictionsNested<A> withNewTemplateInstanceAttributeRestrictionsLike(io.fabric8.openshift.api.model.TemplateInstance item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.TemplateInstanceAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildAttributeRestrictions(io.fabric8.openshift.api.model.Build buildAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.BuildBuilder(buildAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.BuildAttributeRestrictionsNested<A> withNewBuildAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.BuildAttributeRestrictionsNested<A> withNewBuildAttributeRestrictionsLike(io.fabric8.openshift.api.model.Build item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.BuildAttributeRestrictionsNestedImpl(item);
  }
  public A withRoleBindingRestrictionAttributeRestrictions(io.fabric8.openshift.api.model.RoleBindingRestriction roleBindingRestrictionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (roleBindingRestrictionAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder(roleBindingRestrictionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<A> withNewRoleBindingRestrictionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoleBindingRestrictionAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<A> withNewRoleBindingRestrictionAttributeRestrictionsLike(io.fabric8.openshift.api.model.RoleBindingRestriction item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.RoleBindingRestrictionAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamTagAttributeRestrictions(io.fabric8.openshift.api.model.ImageStreamTag imageStreamTagAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamTagAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.ImageStreamTagBuilder(imageStreamTagAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<A> withNewImageStreamTagAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamTagAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<A> withNewImageStreamTagAttributeRestrictionsLike(io.fabric8.openshift.api.model.ImageStreamTag item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.ImageStreamTagAttributeRestrictionsNestedImpl(item);
  }
  public A withGroupAttributeRestrictions(io.fabric8.openshift.api.model.Group groupAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (groupAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.GroupBuilder(groupAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.GroupAttributeRestrictionsNested<A> withNewGroupAttributeRestrictions() {
    return new PolicyRuleFluentImpl.GroupAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.GroupAttributeRestrictionsNested<A> withNewGroupAttributeRestrictionsLike(io.fabric8.openshift.api.model.Group item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.GroupAttributeRestrictionsNestedImpl(item);
  }
  public A withImageSignatureAttributeRestrictions(io.fabric8.openshift.api.model.ImageSignature imageSignatureAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageSignatureAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.ImageSignatureBuilder(imageSignatureAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<A> withNewImageSignatureAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageSignatureAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<A> withNewImageSignatureAttributeRestrictionsLike(io.fabric8.openshift.api.model.ImageSignature item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.ImageSignatureAttributeRestrictionsNestedImpl(item);
  }
  public A withHostSubnetAttributeRestrictions(io.fabric8.openshift.api.model.HostSubnet hostSubnetAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (hostSubnetAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.HostSubnetBuilder(hostSubnetAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.HostSubnetAttributeRestrictionsNested<A> withNewHostSubnetAttributeRestrictions() {
    return new PolicyRuleFluentImpl.HostSubnetAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.HostSubnetAttributeRestrictionsNested<A> withNewHostSubnetAttributeRestrictionsLike(io.fabric8.openshift.api.model.HostSubnet item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.HostSubnetAttributeRestrictionsNestedImpl(item);
  }
  public A withAppliedClusterResourceQuotaAttributeRestrictions(io.fabric8.openshift.api.model.AppliedClusterResourceQuota appliedClusterResourceQuotaAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (appliedClusterResourceQuotaAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder(appliedClusterResourceQuotaAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaAttributeRestrictions() {
    return new PolicyRuleFluentImpl.AppliedClusterResourceQuotaAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaAttributeRestrictionsLike(io.fabric8.openshift.api.model.AppliedClusterResourceQuota item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.AppliedClusterResourceQuotaAttributeRestrictionsNestedImpl(item);
  }
  public A withSecurityContextConstraintsAttributeRestrictions(io.fabric8.openshift.api.model.SecurityContextConstraints securityContextConstraintsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (securityContextConstraintsAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder(securityContextConstraintsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<A> withNewSecurityContextConstraintsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SecurityContextConstraintsAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<A> withNewSecurityContextConstraintsAttributeRestrictionsLike(io.fabric8.openshift.api.model.SecurityContextConstraints item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.SecurityContextConstraintsAttributeRestrictionsNestedImpl(item);
  }
  public A withConsoleAttributeRestrictions(io.fabric8.openshift.api.model.Console consoleAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (consoleAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.ConsoleBuilder(consoleAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.ConsoleAttributeRestrictionsNested<A> withNewConsoleAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ConsoleAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.ConsoleAttributeRestrictionsNested<A> withNewConsoleAttributeRestrictionsLike(io.fabric8.openshift.api.model.Console item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.ConsoleAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildRequestAttributeRestrictions(io.fabric8.openshift.api.model.BuildRequest buildRequestAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildRequestAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.BuildRequestBuilder(buildRequestAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<A> withNewBuildRequestAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildRequestAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<A> withNewBuildRequestAttributeRestrictionsLike(io.fabric8.openshift.api.model.BuildRequest item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.BuildRequestAttributeRestrictionsNestedImpl(item);
  }
  public A withEgressNetworkPolicyAttributeRestrictions(io.fabric8.openshift.api.model.EgressNetworkPolicy egressNetworkPolicyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (egressNetworkPolicyAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder(egressNetworkPolicyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<A> withNewEgressNetworkPolicyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.EgressNetworkPolicyAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<A> withNewEgressNetworkPolicyAttributeRestrictionsLike(io.fabric8.openshift.api.model.EgressNetworkPolicy item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.EgressNetworkPolicyAttributeRestrictionsNestedImpl(item);
  }
  public A withNetNamespaceAttributeRestrictions(io.fabric8.openshift.api.model.NetNamespace netNamespaceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (netNamespaceAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.NetNamespaceBuilder(netNamespaceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<A> withNewNetNamespaceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.NetNamespaceAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<A> withNewNetNamespaceAttributeRestrictionsLike(io.fabric8.openshift.api.model.NetNamespace item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.NetNamespaceAttributeRestrictionsNestedImpl(item);
  }
  public A withUserIdentityMappingAttributeRestrictions(io.fabric8.openshift.api.model.UserIdentityMapping userIdentityMappingAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (userIdentityMappingAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.UserIdentityMappingBuilder(userIdentityMappingAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.UserIdentityMappingAttributeRestrictionsNested<A> withNewUserIdentityMappingAttributeRestrictions() {
    return new PolicyRuleFluentImpl.UserIdentityMappingAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.UserIdentityMappingAttributeRestrictionsNested<A> withNewUserIdentityMappingAttributeRestrictionsLike(io.fabric8.openshift.api.model.UserIdentityMapping item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.UserIdentityMappingAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamAttributeRestrictions(io.fabric8.openshift.api.model.ImageStream imageStreamAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.ImageStreamBuilder(imageStreamAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<A> withNewImageStreamAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<A> withNewImageStreamAttributeRestrictionsLike(io.fabric8.openshift.api.model.ImageStream item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.ImageStreamAttributeRestrictionsNestedImpl(item);
  }
  public A withNetworkAttributeRestrictions(io.fabric8.openshift.api.model.Network networkAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (networkAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.NetworkBuilder(networkAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.NetworkAttributeRestrictionsNested<A> withNewNetworkAttributeRestrictions() {
    return new PolicyRuleFluentImpl.NetworkAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.NetworkAttributeRestrictionsNested<A> withNewNetworkAttributeRestrictionsLike(io.fabric8.openshift.api.model.Network item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.NetworkAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthClientAttributeRestrictions(io.fabric8.openshift.api.model.OAuthClient oAuthClientAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthClientAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.OAuthClientBuilder(oAuthClientAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<A> withNewOAuthClientAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthClientAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<A> withNewOAuthClientAttributeRestrictionsLike(io.fabric8.openshift.api.model.OAuthClient item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.OAuthClientAttributeRestrictionsNestedImpl(item);
  }
  public A withIdentityAttributeRestrictions(io.fabric8.openshift.api.model.Identity identityAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (identityAttributeRestrictions!=null){ this.attributeRestrictions= new io.fabric8.openshift.api.model.IdentityBuilder(identityAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} return (A) this;
  }
  public PolicyRuleFluent.IdentityAttributeRestrictionsNested<A> withNewIdentityAttributeRestrictions() {
    return new PolicyRuleFluentImpl.IdentityAttributeRestrictionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.PolicyRuleFluent.IdentityAttributeRestrictionsNested<A> withNewIdentityAttributeRestrictionsLike(io.fabric8.openshift.api.model.Identity item) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentImpl.IdentityAttributeRestrictionsNestedImpl(item);
  }
  public A addToNonResourceURLs(java.lang.Integer index,java.lang.String item) {
    if (this.nonResourceURLs == null) {this.nonResourceURLs = new java.util.ArrayList<java.lang.String>();}
    this.nonResourceURLs.add(index, item);
    return (A)this;
  }
  public A setToNonResourceURLs(java.lang.Integer index,java.lang.String item) {
    if (this.nonResourceURLs == null) {this.nonResourceURLs = new java.util.ArrayList<java.lang.String>();}
    this.nonResourceURLs.set(index, item); return (A)this;
  }
  public A addToNonResourceURLs(java.lang.String... items) {
    if (this.nonResourceURLs == null) {this.nonResourceURLs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.nonResourceURLs.add(item);} return (A)this;
  }
  public A addAllToNonResourceURLs(java.util.Collection<java.lang.String> items) {
    if (this.nonResourceURLs == null) {this.nonResourceURLs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.nonResourceURLs.add(item);} return (A)this;
  }
  public A removeFromNonResourceURLs(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.nonResourceURLs!= null){ this.nonResourceURLs.remove(item);}} return (A)this;
  }
  public A removeAllFromNonResourceURLs(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.nonResourceURLs!= null){ this.nonResourceURLs.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getNonResourceURLs() {
    return this.nonResourceURLs;
  }
  public java.lang.String getNonResourceURL(java.lang.Integer index) {
    return this.nonResourceURLs.get(index);
  }
  public java.lang.String getFirstNonResourceURL() {
    return this.nonResourceURLs.get(0);
  }
  public java.lang.String getLastNonResourceURL() {
    return this.nonResourceURLs.get(nonResourceURLs.size() - 1);
  }
  public java.lang.String getMatchingNonResourceURL(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: nonResourceURLs) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingNonResourceURL(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: nonResourceURLs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNonResourceURLs(java.util.List<java.lang.String> nonResourceURLs) {
    if (nonResourceURLs != null) {this.nonResourceURLs = new java.util.ArrayList(); for (java.lang.String item : nonResourceURLs){this.addToNonResourceURLs(item);}} else { this.nonResourceURLs = null;} return (A) this;
  }
  public A withNonResourceURLs(java.lang.String... nonResourceURLs) {
    if (this.nonResourceURLs != null) {this.nonResourceURLs.clear();}
    if (nonResourceURLs != null) {for (java.lang.String item :nonResourceURLs){ this.addToNonResourceURLs(item);}} return (A) this;
  }
  public java.lang.Boolean hasNonResourceURLs() {
    return nonResourceURLs != null && !nonResourceURLs.isEmpty();
  }
  public A addToResourceNames(java.lang.Integer index,java.lang.String item) {
    if (this.resourceNames == null) {this.resourceNames = new java.util.ArrayList<java.lang.String>();}
    this.resourceNames.add(index, item);
    return (A)this;
  }
  public A setToResourceNames(java.lang.Integer index,java.lang.String item) {
    if (this.resourceNames == null) {this.resourceNames = new java.util.ArrayList<java.lang.String>();}
    this.resourceNames.set(index, item); return (A)this;
  }
  public A addToResourceNames(java.lang.String... items) {
    if (this.resourceNames == null) {this.resourceNames = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.resourceNames.add(item);} return (A)this;
  }
  public A addAllToResourceNames(java.util.Collection<java.lang.String> items) {
    if (this.resourceNames == null) {this.resourceNames = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.resourceNames.add(item);} return (A)this;
  }
  public A removeFromResourceNames(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.resourceNames!= null){ this.resourceNames.remove(item);}} return (A)this;
  }
  public A removeAllFromResourceNames(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.resourceNames!= null){ this.resourceNames.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getResourceNames() {
    return this.resourceNames;
  }
  public java.lang.String getResourceName(java.lang.Integer index) {
    return this.resourceNames.get(index);
  }
  public java.lang.String getFirstResourceName() {
    return this.resourceNames.get(0);
  }
  public java.lang.String getLastResourceName() {
    return this.resourceNames.get(resourceNames.size() - 1);
  }
  public java.lang.String getMatchingResourceName(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: resourceNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingResourceName(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: resourceNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResourceNames(java.util.List<java.lang.String> resourceNames) {
    if (resourceNames != null) {this.resourceNames = new java.util.ArrayList(); for (java.lang.String item : resourceNames){this.addToResourceNames(item);}} else { this.resourceNames = null;} return (A) this;
  }
  public A withResourceNames(java.lang.String... resourceNames) {
    if (this.resourceNames != null) {this.resourceNames.clear();}
    if (resourceNames != null) {for (java.lang.String item :resourceNames){ this.addToResourceNames(item);}} return (A) this;
  }
  public java.lang.Boolean hasResourceNames() {
    return resourceNames != null && !resourceNames.isEmpty();
  }
  public A addToResources(java.lang.Integer index,java.lang.String item) {
    if (this.resources == null) {this.resources = new java.util.ArrayList<java.lang.String>();}
    this.resources.add(index, item);
    return (A)this;
  }
  public A setToResources(java.lang.Integer index,java.lang.String item) {
    if (this.resources == null) {this.resources = new java.util.ArrayList<java.lang.String>();}
    this.resources.set(index, item); return (A)this;
  }
  public A addToResources(java.lang.String... items) {
    if (this.resources == null) {this.resources = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.resources.add(item);} return (A)this;
  }
  public A addAllToResources(java.util.Collection<java.lang.String> items) {
    if (this.resources == null) {this.resources = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.resources.add(item);} return (A)this;
  }
  public A removeFromResources(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.resources!= null){ this.resources.remove(item);}} return (A)this;
  }
  public A removeAllFromResources(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.resources!= null){ this.resources.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getResources() {
    return this.resources;
  }
  public java.lang.String getResource(java.lang.Integer index) {
    return this.resources.get(index);
  }
  public java.lang.String getFirstResource() {
    return this.resources.get(0);
  }
  public java.lang.String getLastResource() {
    return this.resources.get(resources.size() - 1);
  }
  public java.lang.String getMatchingResource(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: resources) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingResource(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: resources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResources(java.util.List<java.lang.String> resources) {
    if (resources != null) {this.resources = new java.util.ArrayList(); for (java.lang.String item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
  }
  public A withResources(java.lang.String... resources) {
    if (this.resources != null) {this.resources.clear();}
    if (resources != null) {for (java.lang.String item :resources){ this.addToResources(item);}} return (A) this;
  }
  public java.lang.Boolean hasResources() {
    return resources != null && !resources.isEmpty();
  }
  public A addToVerbs(java.lang.Integer index,java.lang.String item) {
    if (this.verbs == null) {this.verbs = new java.util.ArrayList<java.lang.String>();}
    this.verbs.add(index, item);
    return (A)this;
  }
  public A setToVerbs(java.lang.Integer index,java.lang.String item) {
    if (this.verbs == null) {this.verbs = new java.util.ArrayList<java.lang.String>();}
    this.verbs.set(index, item); return (A)this;
  }
  public A addToVerbs(java.lang.String... items) {
    if (this.verbs == null) {this.verbs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.verbs.add(item);} return (A)this;
  }
  public A addAllToVerbs(java.util.Collection<java.lang.String> items) {
    if (this.verbs == null) {this.verbs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.verbs.add(item);} return (A)this;
  }
  public A removeFromVerbs(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.verbs!= null){ this.verbs.remove(item);}} return (A)this;
  }
  public A removeAllFromVerbs(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.verbs!= null){ this.verbs.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getVerbs() {
    return this.verbs;
  }
  public java.lang.String getVerb(java.lang.Integer index) {
    return this.verbs.get(index);
  }
  public java.lang.String getFirstVerb() {
    return this.verbs.get(0);
  }
  public java.lang.String getLastVerb() {
    return this.verbs.get(verbs.size() - 1);
  }
  public java.lang.String getMatchingVerb(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: verbs) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingVerb(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: verbs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVerbs(java.util.List<java.lang.String> verbs) {
    if (verbs != null) {this.verbs = new java.util.ArrayList(); for (java.lang.String item : verbs){this.addToVerbs(item);}} else { this.verbs = null;} return (A) this;
  }
  public A withVerbs(java.lang.String... verbs) {
    if (this.verbs != null) {this.verbs.clear();}
    if (verbs != null) {for (java.lang.String item :verbs){ this.addToVerbs(item);}} return (A) this;
  }
  public java.lang.Boolean hasVerbs() {
    return verbs != null && !verbs.isEmpty();
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PolicyRuleFluentImpl that = (PolicyRuleFluentImpl) o;
    if (apiGroups != null ? !apiGroups.equals(that.apiGroups) :that.apiGroups != null) return false;
    if (attributeRestrictions != null ? !attributeRestrictions.equals(that.attributeRestrictions) :that.attributeRestrictions != null) return false;
    if (nonResourceURLs != null ? !nonResourceURLs.equals(that.nonResourceURLs) :that.nonResourceURLs != null) return false;
    if (resourceNames != null ? !resourceNames.equals(that.resourceNames) :that.resourceNames != null) return false;
    if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
    if (verbs != null ? !verbs.equals(that.verbs) :that.verbs != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiGroups,  attributeRestrictions,  nonResourceURLs,  resourceNames,  resources,  verbs,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiGroups != null && !apiGroups.isEmpty()) { sb.append("apiGroups:"); sb.append(apiGroups + ","); }
    if (attributeRestrictions != null) { sb.append("attributeRestrictions:"); sb.append(attributeRestrictions + ","); }
    if (nonResourceURLs != null && !nonResourceURLs.isEmpty()) { sb.append("nonResourceURLs:"); sb.append(nonResourceURLs + ","); }
    if (resourceNames != null && !resourceNames.isEmpty()) { sb.append("resourceNames:"); sb.append(resourceNames + ","); }
    if (resources != null && !resources.isEmpty()) { sb.append("resources:"); sb.append(resources + ","); }
    if (verbs != null && !verbs.isEmpty()) { sb.append("verbs:"); sb.append(verbs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ClusterVersionAttributeRestrictionsNestedImpl<N> extends ClusterVersionFluentImpl<PolicyRuleFluent.ClusterVersionAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterVersionAttributeRestrictionsNested<N>,Nested<N>{
    ClusterVersionAttributeRestrictionsNestedImpl(ClusterVersion item) {
      this.builder = new ClusterVersionBuilder(this, item);
    }
    ClusterVersionAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ClusterVersionBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterVersionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterVersionAttributeRestrictions() {
      return and();
    }
    
  }
  class DNSAttributeRestrictionsNestedImpl<N> extends DNSFluentImpl<PolicyRuleFluent.DNSAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.DNSAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DNSAttributeRestrictionsNestedImpl(DNS item) {
      this.builder = new DNSBuilder(this, item);
    }
    DNSAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.DNSBuilder(this);
    }
    io.fabric8.openshift.api.model.DNSBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDNSAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamImportAttributeRestrictionsNestedImpl<N> extends ImageStreamImportFluentImpl<PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageStreamImportAttributeRestrictionsNestedImpl(ImageStreamImport item) {
      this.builder = new ImageStreamImportBuilder(this, item);
    }
    ImageStreamImportAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageStreamImportBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageStreamImportBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamImportAttributeRestrictions() {
      return and();
    }
    
  }
  class ProxyAttributeRestrictionsNestedImpl<N> extends ProxyFluentImpl<PolicyRuleFluent.ProxyAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.ProxyAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ProxyAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.Proxy item) {
      this.builder = new ProxyBuilder(this, item);
    }
    ProxyAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ProxyBuilder(this);
    }
    io.fabric8.openshift.api.model.ProxyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endProxyAttributeRestrictions() {
      return and();
    }
    
  }
  class ProjectAttributeRestrictionsNestedImpl<N> extends ProjectFluentImpl<PolicyRuleFluent.ProjectAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.ProjectAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ProjectAttributeRestrictionsNestedImpl(Project item) {
      this.builder = new ProjectBuilder(this, item);
    }
    ProjectAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ProjectBuilder(this);
    }
    io.fabric8.openshift.api.model.ProjectBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endProjectAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterOperatorAttributeRestrictionsNestedImpl<N> extends ClusterOperatorFluentImpl<PolicyRuleFluent.ClusterOperatorAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterOperatorAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterOperatorAttributeRestrictionsNestedImpl(ClusterOperator item) {
      this.builder = new ClusterOperatorBuilder(this, item);
    }
    ClusterOperatorAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ClusterOperatorBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterOperatorBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterOperatorAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildConfigAttributeRestrictionsNestedImpl<N> extends BuildConfigFluentImpl<PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BuildConfigAttributeRestrictionsNestedImpl(BuildConfig item) {
      this.builder = new BuildConfigBuilder(this, item);
    }
    BuildConfigAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.BuildConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildConfigBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildConfigAttributeRestrictions() {
      return and();
    }
    
  }
  class HelmChartRepositoryAttributeRestrictionsNestedImpl<N> extends HelmChartRepositoryFluentImpl<PolicyRuleFluent.HelmChartRepositoryAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.HelmChartRepositoryAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    HelmChartRepositoryAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.HelmChartRepository item) {
      this.builder = new HelmChartRepositoryBuilder(this, item);
    }
    HelmChartRepositoryAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.HelmChartRepositoryBuilder(this);
    }
    io.fabric8.openshift.api.model.HelmChartRepositoryBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endHelmChartRepositoryAttributeRestrictions() {
      return and();
    }
    
  }
  class InfrastructureAttributeRestrictionsNestedImpl<N> extends InfrastructureFluentImpl<PolicyRuleFluent.InfrastructureAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.InfrastructureAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    InfrastructureAttributeRestrictionsNestedImpl(Infrastructure item) {
      this.builder = new InfrastructureBuilder(this, item);
    }
    InfrastructureAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.InfrastructureBuilder(this);
    }
    io.fabric8.openshift.api.model.InfrastructureBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endInfrastructureAttributeRestrictions() {
      return and();
    }
    
  }
  class SchedulerAttributeRestrictionsNestedImpl<N> extends SchedulerFluentImpl<PolicyRuleFluent.SchedulerAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.SchedulerAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SchedulerAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.Scheduler item) {
      this.builder = new SchedulerBuilder(this, item);
    }
    SchedulerAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.SchedulerBuilder(this);
    }
    io.fabric8.openshift.api.model.SchedulerBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSchedulerAttributeRestrictions() {
      return and();
    }
    
  }
  class RangeAllocationAttributeRestrictionsNestedImpl<N> extends RangeAllocationFluentImpl<PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RangeAllocationAttributeRestrictionsNestedImpl(RangeAllocation item) {
      this.builder = new RangeAllocationBuilder(this, item);
    }
    RangeAllocationAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.RangeAllocationBuilder(this);
    }
    io.fabric8.openshift.api.model.RangeAllocationBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRangeAllocationAttributeRestrictions() {
      return and();
    }
    
  }
  class RouteAttributeRestrictionsNestedImpl<N> extends RouteFluentImpl<PolicyRuleFluent.RouteAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.RouteAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RouteAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.Route item) {
      this.builder = new RouteBuilder(this, item);
    }
    RouteAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.RouteBuilder(this);
    }
    io.fabric8.openshift.api.model.RouteBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRouteAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterNetworkAttributeRestrictionsNestedImpl<N> extends ClusterNetworkFluentImpl<PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterNetworkAttributeRestrictionsNestedImpl(ClusterNetwork item) {
      this.builder = new ClusterNetworkBuilder(this, item);
    }
    ClusterNetworkAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ClusterNetworkBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterNetworkBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterNetworkAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthAuthorizeTokenAttributeRestrictionsNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OAuthAuthorizeTokenAttributeRestrictionsNestedImpl(OAuthAuthorizeToken item) {
      this.builder = new OAuthAuthorizeTokenBuilder(this, item);
    }
    OAuthAuthorizeTokenAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder(this);
    }
    io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthAuthorizeTokenAttributeRestrictions() {
      return and();
    }
    
  }
  class UserOAuthAccessTokenAttributeRestrictionsNestedImpl<N> extends UserOAuthAccessTokenFluentImpl<PolicyRuleFluent.UserOAuthAccessTokenAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.UserOAuthAccessTokenAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UserOAuthAccessTokenAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.UserOAuthAccessToken item) {
      this.builder = new UserOAuthAccessTokenBuilder(this, item);
    }
    UserOAuthAccessTokenAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder(this);
    }
    io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endUserOAuthAccessTokenAttributeRestrictions() {
      return and();
    }
    
  }
  class IngressAttributeRestrictionsNestedImpl<N> extends IngressFluentImpl<PolicyRuleFluent.IngressAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.IngressAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    IngressAttributeRestrictionsNestedImpl(Ingress item) {
      this.builder = new IngressBuilder(this, item);
    }
    IngressAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.IngressBuilder(this);
    }
    io.fabric8.openshift.api.model.IngressBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endIngressAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthAttributeRestrictionsNestedImpl<N> extends OAuthFluentImpl<PolicyRuleFluent.OAuthAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OAuthAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.OAuth item) {
      this.builder = new OAuthBuilder(this, item);
    }
    OAuthAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OAuthBuilder(this);
    }
    io.fabric8.openshift.api.model.OAuthBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthAttributeRestrictions() {
      return and();
    }
    
  }
  class OperatorHubAttributeRestrictionsNestedImpl<N> extends OperatorHubFluentImpl<PolicyRuleFluent.OperatorHubAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.OperatorHubAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OperatorHubAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.OperatorHub item) {
      this.builder = new OperatorHubBuilder(this, item);
    }
    OperatorHubAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OperatorHubBuilder(this);
    }
    io.fabric8.openshift.api.model.OperatorHubBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOperatorHubAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterRoleBindingAttributeRestrictionsNestedImpl<N> extends ClusterRoleBindingFluentImpl<PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterRoleBindingAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.ClusterRoleBinding item) {
      this.builder = new ClusterRoleBindingBuilder(this, item);
    }
    ClusterRoleBindingAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ClusterRoleBindingBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterRoleBindingBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterRoleBindingAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterResourceQuotaAttributeRestrictionsNestedImpl<N> extends ClusterResourceQuotaFluentImpl<PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterResourceQuotaAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.ClusterResourceQuota item) {
      this.builder = new ClusterResourceQuotaBuilder(this, item);
    }
    ClusterResourceQuotaAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterResourceQuotaBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterResourceQuotaAttributeRestrictions() {
      return and();
    }
    
  }
  class ProjectRequestAttributeRestrictionsNestedImpl<N> extends ProjectRequestFluentImpl<PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ProjectRequestAttributeRestrictionsNestedImpl(ProjectRequest item) {
      this.builder = new ProjectRequestBuilder(this, item);
    }
    ProjectRequestAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ProjectRequestBuilder(this);
    }
    io.fabric8.openshift.api.model.ProjectRequestBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endProjectRequestAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateAttributeRestrictionsNestedImpl<N> extends TemplateFluentImpl<PolicyRuleFluent.TemplateAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.TemplateAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TemplateAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.Template item) {
      this.builder = new TemplateBuilder(this, item);
    }
    TemplateAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.TemplateBuilder(this);
    }
    io.fabric8.openshift.api.model.TemplateBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthClientAuthorizationAttributeRestrictionsNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OAuthClientAuthorizationAttributeRestrictionsNestedImpl(OAuthClientAuthorization item) {
      this.builder = new OAuthClientAuthorizationBuilder(this, item);
    }
    OAuthClientAuthorizationAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder(this);
    }
    io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthClientAuthorizationAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterRoleAttributeRestrictionsNestedImpl<N> extends ClusterRoleFluentImpl<PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClusterRoleAttributeRestrictionsNestedImpl(ClusterRole item) {
      this.builder = new ClusterRoleBuilder(this, item);
    }
    ClusterRoleAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ClusterRoleBuilder(this);
    }
    io.fabric8.openshift.api.model.ClusterRoleBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterRoleAttributeRestrictions() {
      return and();
    }
    
  }
  class AuthenticationAttributeRestrictionsNestedImpl<N> extends AuthenticationFluentImpl<PolicyRuleFluent.AuthenticationAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.AuthenticationAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AuthenticationAttributeRestrictionsNestedImpl(Authentication item) {
      this.builder = new AuthenticationBuilder(this, item);
    }
    AuthenticationAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.AuthenticationBuilder(this);
    }
    io.fabric8.openshift.api.model.AuthenticationBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endAuthenticationAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageTagAttributeRestrictionsNestedImpl<N> extends ImageTagFluentImpl<PolicyRuleFluent.ImageTagAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.ImageTagAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageTagAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.ImageTag item) {
      this.builder = new ImageTagBuilder(this, item);
    }
    ImageTagAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageTagBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageTagBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageTagAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthAccessTokenAttributeRestrictionsNestedImpl<N> extends OAuthAccessTokenFluentImpl<PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OAuthAccessTokenAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.OAuthAccessToken item) {
      this.builder = new OAuthAccessTokenBuilder(this, item);
    }
    OAuthAccessTokenAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OAuthAccessTokenBuilder(this);
    }
    io.fabric8.openshift.api.model.OAuthAccessTokenBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthAccessTokenAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentConfigAttributeRestrictionsNestedImpl<N> extends DeploymentConfigFluentImpl<PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DeploymentConfigAttributeRestrictionsNestedImpl(DeploymentConfig item) {
      this.builder = new DeploymentConfigBuilder(this, item);
    }
    DeploymentConfigAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.DeploymentConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.DeploymentConfigBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentConfigAttributeRestrictions() {
      return and();
    }
    
  }
  class RoleBindingAttributeRestrictionsNestedImpl<N> extends RoleBindingFluentImpl<PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RoleBindingAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.RoleBinding item) {
      this.builder = new RoleBindingBuilder(this, item);
    }
    RoleBindingAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.RoleBindingBuilder(this);
    }
    io.fabric8.openshift.api.model.RoleBindingBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleBindingAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageAttributeRestrictionsNestedImpl<N> extends ImageFluentImpl<PolicyRuleFluent.ImageAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.ImageAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageAttributeRestrictionsNestedImpl(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageAttributeRestrictions() {
      return and();
    }
    
  }
  class APIServerAttributeRestrictionsNestedImpl<N> extends APIServerFluentImpl<PolicyRuleFluent.APIServerAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.APIServerAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    APIServerAttributeRestrictionsNestedImpl(APIServer item) {
      this.builder = new APIServerBuilder(this, item);
    }
    APIServerAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.APIServerBuilder(this);
    }
    io.fabric8.openshift.api.model.APIServerBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endAPIServerAttributeRestrictions() {
      return and();
    }
    
  }
  class PersistentVolumeClaimAttributeRestrictionsNestedImpl<N> extends PersistentVolumeClaimFluentImpl<PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PersistentVolumeClaimAttributeRestrictionsNestedImpl(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPersistentVolumeClaimAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamMappingAttributeRestrictionsNestedImpl<N> extends ImageStreamMappingFluentImpl<PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageStreamMappingAttributeRestrictionsNestedImpl(ImageStreamMapping item) {
      this.builder = new ImageStreamMappingBuilder(this, item);
    }
    ImageStreamMappingAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageStreamMappingBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageStreamMappingBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamMappingAttributeRestrictions() {
      return and();
    }
    
  }
  class RoleAttributeRestrictionsNestedImpl<N> extends RoleFluentImpl<PolicyRuleFluent.RoleAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.RoleAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RoleAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.Role item) {
      this.builder = new RoleBuilder(this, item);
    }
    RoleAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.RoleBuilder(this);
    }
    io.fabric8.openshift.api.model.RoleBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleAttributeRestrictions() {
      return and();
    }
    
  }
  class BrokerTemplateInstanceAttributeRestrictionsNestedImpl<N> extends BrokerTemplateInstanceFluentImpl<PolicyRuleFluent.BrokerTemplateInstanceAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.BrokerTemplateInstanceAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BrokerTemplateInstanceAttributeRestrictionsNestedImpl(BrokerTemplateInstance item) {
      this.builder = new BrokerTemplateInstanceBuilder(this, item);
    }
    BrokerTemplateInstanceAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder(this);
    }
    io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBrokerTemplateInstanceAttributeRestrictions() {
      return and();
    }
    
  }
  class FeatureGateAttributeRestrictionsNestedImpl<N> extends FeatureGateFluentImpl<PolicyRuleFluent.FeatureGateAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.FeatureGateAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    FeatureGateAttributeRestrictionsNestedImpl(FeatureGate item) {
      this.builder = new FeatureGateBuilder(this, item);
    }
    FeatureGateAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.FeatureGateBuilder(this);
    }
    io.fabric8.openshift.api.model.FeatureGateBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endFeatureGateAttributeRestrictions() {
      return and();
    }
    
  }
  class UserAttributeRestrictionsNestedImpl<N> extends UserFluentImpl<PolicyRuleFluent.UserAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.UserAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UserAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.User item) {
      this.builder = new UserBuilder(this, item);
    }
    UserAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.UserBuilder(this);
    }
    io.fabric8.openshift.api.model.UserBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endUserAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamImageAttributeRestrictionsNestedImpl<N> extends ImageStreamImageFluentImpl<PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageStreamImageAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.ImageStreamImage item) {
      this.builder = new ImageStreamImageBuilder(this, item);
    }
    ImageStreamImageAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageStreamImageBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageStreamImageBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamImageAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateInstanceAttributeRestrictionsNestedImpl<N> extends TemplateInstanceFluentImpl<PolicyRuleFluent.TemplateInstanceAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.TemplateInstanceAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TemplateInstanceAttributeRestrictionsNestedImpl(TemplateInstance item) {
      this.builder = new TemplateInstanceBuilder(this, item);
    }
    TemplateInstanceAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.TemplateInstanceBuilder(this);
    }
    io.fabric8.openshift.api.model.TemplateInstanceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateInstanceAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildAttributeRestrictionsNestedImpl<N> extends BuildFluentImpl<PolicyRuleFluent.BuildAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.BuildAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BuildAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.Build item) {
      this.builder = new BuildBuilder(this, item);
    }
    BuildAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.BuildBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildAttributeRestrictions() {
      return and();
    }
    
  }
  class RoleBindingRestrictionAttributeRestrictionsNestedImpl<N> extends RoleBindingRestrictionFluentImpl<PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RoleBindingRestrictionAttributeRestrictionsNestedImpl(RoleBindingRestriction item) {
      this.builder = new RoleBindingRestrictionBuilder(this, item);
    }
    RoleBindingRestrictionAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder(this);
    }
    io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleBindingRestrictionAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamTagAttributeRestrictionsNestedImpl<N> extends ImageStreamTagFluentImpl<PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageStreamTagAttributeRestrictionsNestedImpl(ImageStreamTag item) {
      this.builder = new ImageStreamTagBuilder(this, item);
    }
    ImageStreamTagAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageStreamTagBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageStreamTagBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamTagAttributeRestrictions() {
      return and();
    }
    
  }
  class GroupAttributeRestrictionsNestedImpl<N> extends GroupFluentImpl<PolicyRuleFluent.GroupAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.GroupAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GroupAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.Group item) {
      this.builder = new GroupBuilder(this, item);
    }
    GroupAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.GroupBuilder(this);
    }
    io.fabric8.openshift.api.model.GroupBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGroupAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageSignatureAttributeRestrictionsNestedImpl<N> extends ImageSignatureFluentImpl<PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageSignatureAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.ImageSignature item) {
      this.builder = new ImageSignatureBuilder(this, item);
    }
    ImageSignatureAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageSignatureBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageSignatureBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageSignatureAttributeRestrictions() {
      return and();
    }
    
  }
  class HostSubnetAttributeRestrictionsNestedImpl<N> extends HostSubnetFluentImpl<PolicyRuleFluent.HostSubnetAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.HostSubnetAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    HostSubnetAttributeRestrictionsNestedImpl(HostSubnet item) {
      this.builder = new HostSubnetBuilder(this, item);
    }
    HostSubnetAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.HostSubnetBuilder(this);
    }
    io.fabric8.openshift.api.model.HostSubnetBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endHostSubnetAttributeRestrictions() {
      return and();
    }
    
  }
  class AppliedClusterResourceQuotaAttributeRestrictionsNestedImpl<N> extends AppliedClusterResourceQuotaFluentImpl<PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AppliedClusterResourceQuotaAttributeRestrictionsNestedImpl(AppliedClusterResourceQuota item) {
      this.builder = new AppliedClusterResourceQuotaBuilder(this, item);
    }
    AppliedClusterResourceQuotaAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder(this);
    }
    io.fabric8.openshift.api.model.AppliedClusterResourceQuotaBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endAppliedClusterResourceQuotaAttributeRestrictions() {
      return and();
    }
    
  }
  class SecurityContextConstraintsAttributeRestrictionsNestedImpl<N> extends SecurityContextConstraintsFluentImpl<PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SecurityContextConstraintsAttributeRestrictionsNestedImpl(SecurityContextConstraints item) {
      this.builder = new SecurityContextConstraintsBuilder(this, item);
    }
    SecurityContextConstraintsAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder(this);
    }
    io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSecurityContextConstraintsAttributeRestrictions() {
      return and();
    }
    
  }
  class ConsoleAttributeRestrictionsNestedImpl<N> extends ConsoleFluentImpl<PolicyRuleFluent.ConsoleAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.ConsoleAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConsoleAttributeRestrictionsNestedImpl(Console item) {
      this.builder = new ConsoleBuilder(this, item);
    }
    ConsoleAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ConsoleBuilder(this);
    }
    io.fabric8.openshift.api.model.ConsoleBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endConsoleAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildRequestAttributeRestrictionsNestedImpl<N> extends BuildRequestFluentImpl<PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BuildRequestAttributeRestrictionsNestedImpl(BuildRequest item) {
      this.builder = new BuildRequestBuilder(this, item);
    }
    BuildRequestAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.BuildRequestBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildRequestBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildRequestAttributeRestrictions() {
      return and();
    }
    
  }
  class EgressNetworkPolicyAttributeRestrictionsNestedImpl<N> extends EgressNetworkPolicyFluentImpl<PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    EgressNetworkPolicyAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.EgressNetworkPolicy item) {
      this.builder = new EgressNetworkPolicyBuilder(this, item);
    }
    EgressNetworkPolicyAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder(this);
    }
    io.fabric8.openshift.api.model.EgressNetworkPolicyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endEgressNetworkPolicyAttributeRestrictions() {
      return and();
    }
    
  }
  class NetNamespaceAttributeRestrictionsNestedImpl<N> extends NetNamespaceFluentImpl<PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NetNamespaceAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.NetNamespace item) {
      this.builder = new NetNamespaceBuilder(this, item);
    }
    NetNamespaceAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.NetNamespaceBuilder(this);
    }
    io.fabric8.openshift.api.model.NetNamespaceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endNetNamespaceAttributeRestrictions() {
      return and();
    }
    
  }
  class UserIdentityMappingAttributeRestrictionsNestedImpl<N> extends UserIdentityMappingFluentImpl<PolicyRuleFluent.UserIdentityMappingAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.UserIdentityMappingAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UserIdentityMappingAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.UserIdentityMapping item) {
      this.builder = new UserIdentityMappingBuilder(this, item);
    }
    UserIdentityMappingAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.UserIdentityMappingBuilder(this);
    }
    io.fabric8.openshift.api.model.UserIdentityMappingBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endUserIdentityMappingAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamAttributeRestrictionsNestedImpl<N> extends ImageStreamFluentImpl<PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImageStreamAttributeRestrictionsNestedImpl(ImageStream item) {
      this.builder = new ImageStreamBuilder(this, item);
    }
    ImageStreamAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageStreamBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageStreamBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamAttributeRestrictions() {
      return and();
    }
    
  }
  class NetworkAttributeRestrictionsNestedImpl<N> extends NetworkFluentImpl<PolicyRuleFluent.NetworkAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.NetworkAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NetworkAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.Network item) {
      this.builder = new NetworkBuilder(this, item);
    }
    NetworkAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.NetworkBuilder(this);
    }
    io.fabric8.openshift.api.model.NetworkBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endNetworkAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthClientAttributeRestrictionsNestedImpl<N> extends OAuthClientFluentImpl<PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    OAuthClientAttributeRestrictionsNestedImpl(io.fabric8.openshift.api.model.OAuthClient item) {
      this.builder = new OAuthClientBuilder(this, item);
    }
    OAuthClientAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OAuthClientBuilder(this);
    }
    io.fabric8.openshift.api.model.OAuthClientBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthClientAttributeRestrictions() {
      return and();
    }
    
  }
  class IdentityAttributeRestrictionsNestedImpl<N> extends IdentityFluentImpl<PolicyRuleFluent.IdentityAttributeRestrictionsNested<N>> implements io.fabric8.openshift.api.model.PolicyRuleFluent.IdentityAttributeRestrictionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    IdentityAttributeRestrictionsNestedImpl(Identity item) {
      this.builder = new IdentityBuilder(this, item);
    }
    IdentityAttributeRestrictionsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.IdentityBuilder(this);
    }
    io.fabric8.openshift.api.model.IdentityBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endIdentityAttributeRestrictions() {
      return and();
    }
    
  }
  
}