package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProjectBuilder extends ProjectFluentImpl<ProjectBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.Project,ProjectBuilder>{
  public ProjectBuilder() {
    this(false);
  }
  public ProjectBuilder(Boolean validationEnabled) {
    this(new Project(), validationEnabled);
  }
  public ProjectBuilder(ProjectFluent<?> fluent) {
    this(fluent, false);
  }
  public ProjectBuilder(io.fabric8.openshift.api.model.ProjectFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Project(), validationEnabled);
  }
  public ProjectBuilder(io.fabric8.openshift.api.model.ProjectFluent<?> fluent,io.fabric8.openshift.api.model.Project instance) {
    this(fluent, instance, false);
  }
  public ProjectBuilder(io.fabric8.openshift.api.model.ProjectFluent<?> fluent,io.fabric8.openshift.api.model.Project instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProjectBuilder(io.fabric8.openshift.api.model.Project instance) {
    this(instance,false);
  }
  public ProjectBuilder(io.fabric8.openshift.api.model.Project instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ProjectFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.Project build() {
    Project buildable = new Project(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}