package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProjectListBuilder extends ProjectListFluentImpl<ProjectListBuilder> implements VisitableBuilder<ProjectList,io.fabric8.openshift.api.model.ProjectListBuilder>{
  public ProjectListBuilder() {
    this(false);
  }
  public ProjectListBuilder(Boolean validationEnabled) {
    this(new ProjectList(), validationEnabled);
  }
  public ProjectListBuilder(ProjectListFluent<?> fluent) {
    this(fluent, false);
  }
  public ProjectListBuilder(io.fabric8.openshift.api.model.ProjectListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ProjectList(), validationEnabled);
  }
  public ProjectListBuilder(io.fabric8.openshift.api.model.ProjectListFluent<?> fluent,io.fabric8.openshift.api.model.ProjectList instance) {
    this(fluent, instance, false);
  }
  public ProjectListBuilder(io.fabric8.openshift.api.model.ProjectListFluent<?> fluent,io.fabric8.openshift.api.model.ProjectList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProjectListBuilder(io.fabric8.openshift.api.model.ProjectList instance) {
    this(instance,false);
  }
  public ProjectListBuilder(io.fabric8.openshift.api.model.ProjectList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ProjectListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ProjectList build() {
    ProjectList buildable = new ProjectList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}