package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProjectRequestBuilder extends ProjectRequestFluentImpl<ProjectRequestBuilder> implements VisitableBuilder<ProjectRequest,io.fabric8.openshift.api.model.ProjectRequestBuilder>{
  public ProjectRequestBuilder() {
    this(false);
  }
  public ProjectRequestBuilder(Boolean validationEnabled) {
    this(new ProjectRequest(), validationEnabled);
  }
  public ProjectRequestBuilder(ProjectRequestFluent<?> fluent) {
    this(fluent, false);
  }
  public ProjectRequestBuilder(io.fabric8.openshift.api.model.ProjectRequestFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ProjectRequest(), validationEnabled);
  }
  public ProjectRequestBuilder(io.fabric8.openshift.api.model.ProjectRequestFluent<?> fluent,io.fabric8.openshift.api.model.ProjectRequest instance) {
    this(fluent, instance, false);
  }
  public ProjectRequestBuilder(io.fabric8.openshift.api.model.ProjectRequestFluent<?> fluent,io.fabric8.openshift.api.model.ProjectRequest instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withDescription(instance.getDescription()); 
    fluent.withDisplayName(instance.getDisplayName()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProjectRequestBuilder(io.fabric8.openshift.api.model.ProjectRequest instance) {
    this(instance,false);
  }
  public ProjectRequestBuilder(io.fabric8.openshift.api.model.ProjectRequest instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withDescription(instance.getDescription()); 
    this.withDisplayName(instance.getDisplayName()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ProjectRequestFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ProjectRequest build() {
    ProjectRequest buildable = new ProjectRequest(fluent.getApiVersion(),fluent.getDescription(),fluent.getDisplayName(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}