package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.NamespaceCondition;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ProjectStatusFluentImpl<A extends ProjectStatusFluent<A>> extends BaseFluent<A> implements ProjectStatusFluent<A>{
  public ProjectStatusFluentImpl() {
  }
  public ProjectStatusFluentImpl(io.fabric8.openshift.api.model.ProjectStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withPhase(instance.getPhase()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<NamespaceCondition> conditions = new ArrayList<io.fabric8.kubernetes.api.model.NamespaceCondition>();
  private String phase;
  private Map<java.lang.String,Object> additionalProperties;
  public A addToConditions(Integer index,io.fabric8.kubernetes.api.model.NamespaceCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamespaceCondition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.NamespaceCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamespaceCondition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.NamespaceCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamespaceCondition>();}
    for (io.fabric8.kubernetes.api.model.NamespaceCondition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(Collection<io.fabric8.kubernetes.api.model.NamespaceCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NamespaceCondition>();}
    for (io.fabric8.kubernetes.api.model.NamespaceCondition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.NamespaceCondition... items) {
    for (io.fabric8.kubernetes.api.model.NamespaceCondition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.NamespaceCondition> items) {
    for (io.fabric8.kubernetes.api.model.NamespaceCondition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.NamespaceCondition> getConditions() {
    return this.conditions;
  }
  public io.fabric8.kubernetes.api.model.NamespaceCondition getCondition(java.lang.Integer index) {
    return this.conditions.get(index);
  }
  public io.fabric8.kubernetes.api.model.NamespaceCondition getFirstCondition() {
    return this.conditions.get(0);
  }
  public io.fabric8.kubernetes.api.model.NamespaceCondition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.NamespaceCondition getMatchingCondition(Predicate<io.fabric8.kubernetes.api.model.NamespaceCondition> predicate) {
    for (io.fabric8.kubernetes.api.model.NamespaceCondition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NamespaceCondition> predicate) {
    for (io.fabric8.kubernetes.api.model.NamespaceCondition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.NamespaceCondition> conditions) {
    if (conditions != null) {this.conditions = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.NamespaceCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.NamespaceCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.kubernetes.api.model.NamespaceCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(java.lang.String lastTransitionTime,java.lang.String message,java.lang.String reason,java.lang.String status,java.lang.String type) {
    return (A)addToConditions(new NamespaceCondition(lastTransitionTime, message, reason, status, type));
  }
  public java.lang.String getPhase() {
    return this.phase;
  }
  public A withPhase(java.lang.String phase) {
    this.phase=phase; return (A) this;
  }
  public java.lang.Boolean hasPhase() {
    return this.phase != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProjectStatusFluentImpl that = (ProjectStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  phase,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}