package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProxyStatusBuilder extends ProxyStatusFluentImpl<ProxyStatusBuilder> implements VisitableBuilder<ProxyStatus,io.fabric8.openshift.api.model.ProxyStatusBuilder>{
  public ProxyStatusBuilder() {
    this(false);
  }
  public ProxyStatusBuilder(Boolean validationEnabled) {
    this(new ProxyStatus(), validationEnabled);
  }
  public ProxyStatusBuilder(ProxyStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ProxyStatusBuilder(io.fabric8.openshift.api.model.ProxyStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ProxyStatus(), validationEnabled);
  }
  public ProxyStatusBuilder(io.fabric8.openshift.api.model.ProxyStatusFluent<?> fluent,io.fabric8.openshift.api.model.ProxyStatus instance) {
    this(fluent, instance, false);
  }
  public ProxyStatusBuilder(io.fabric8.openshift.api.model.ProxyStatusFluent<?> fluent,io.fabric8.openshift.api.model.ProxyStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHttpProxy(instance.getHttpProxy()); 
    fluent.withHttpsProxy(instance.getHttpsProxy()); 
    fluent.withNoProxy(instance.getNoProxy()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProxyStatusBuilder(io.fabric8.openshift.api.model.ProxyStatus instance) {
    this(instance,false);
  }
  public ProxyStatusBuilder(io.fabric8.openshift.api.model.ProxyStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHttpProxy(instance.getHttpProxy()); 
    this.withHttpsProxy(instance.getHttpsProxy()); 
    this.withNoProxy(instance.getNoProxy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ProxyStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ProxyStatus build() {
    ProxyStatus buildable = new ProxyStatus(fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}