package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReleaseBuilder extends ReleaseFluentImpl<ReleaseBuilder> implements VisitableBuilder<Release,io.fabric8.openshift.api.model.ReleaseBuilder>{
  public ReleaseBuilder() {
    this(false);
  }
  public ReleaseBuilder(Boolean validationEnabled) {
    this(new Release(), validationEnabled);
  }
  public ReleaseBuilder(ReleaseFluent<?> fluent) {
    this(fluent, false);
  }
  public ReleaseBuilder(io.fabric8.openshift.api.model.ReleaseFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Release(), validationEnabled);
  }
  public ReleaseBuilder(io.fabric8.openshift.api.model.ReleaseFluent<?> fluent,io.fabric8.openshift.api.model.Release instance) {
    this(fluent, instance, false);
  }
  public ReleaseBuilder(io.fabric8.openshift.api.model.ReleaseFluent<?> fluent,io.fabric8.openshift.api.model.Release instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withChannels(instance.getChannels()); 
    fluent.withImage(instance.getImage()); 
    fluent.withUrl(instance.getUrl()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReleaseBuilder(io.fabric8.openshift.api.model.Release instance) {
    this(instance,false);
  }
  public ReleaseBuilder(io.fabric8.openshift.api.model.Release instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withChannels(instance.getChannels()); 
    this.withImage(instance.getImage()); 
    this.withUrl(instance.getUrl()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ReleaseFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.Release build() {
    Release buildable = new Release(fluent.getChannels(),fluent.getImage(),fluent.getUrl(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}