package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ReleaseFluentImpl<A extends ReleaseFluent<A>> extends BaseFluent<A> implements ReleaseFluent<A>{
  public ReleaseFluentImpl() {
  }
  public ReleaseFluentImpl(io.fabric8.openshift.api.model.Release instance) {
    this.withChannels(instance.getChannels()); 
    this.withImage(instance.getImage()); 
    this.withUrl(instance.getUrl()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> channels = new ArrayList<java.lang.String>();
  private java.lang.String image;
  private java.lang.String url;
  private java.lang.String version;
  private Map<java.lang.String,Object> additionalProperties;
  public A addToChannels(Integer index,java.lang.String item) {
    if (this.channels == null) {this.channels = new java.util.ArrayList<java.lang.String>();}
    this.channels.add(index, item);
    return (A)this;
  }
  public A setToChannels(java.lang.Integer index,java.lang.String item) {
    if (this.channels == null) {this.channels = new java.util.ArrayList<java.lang.String>();}
    this.channels.set(index, item); return (A)this;
  }
  public A addToChannels(java.lang.String... items) {
    if (this.channels == null) {this.channels = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.channels.add(item);} return (A)this;
  }
  public A addAllToChannels(Collection<java.lang.String> items) {
    if (this.channels == null) {this.channels = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.channels.add(item);} return (A)this;
  }
  public A removeFromChannels(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.channels!= null){ this.channels.remove(item);}} return (A)this;
  }
  public A removeAllFromChannels(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.channels!= null){ this.channels.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getChannels() {
    return this.channels;
  }
  public java.lang.String getChannel(java.lang.Integer index) {
    return this.channels.get(index);
  }
  public java.lang.String getFirstChannel() {
    return this.channels.get(0);
  }
  public java.lang.String getLastChannel() {
    return this.channels.get(channels.size() - 1);
  }
  public java.lang.String getMatchingChannel(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: channels) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingChannel(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: channels) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withChannels(java.util.List<java.lang.String> channels) {
    if (channels != null) {this.channels = new java.util.ArrayList(); for (java.lang.String item : channels){this.addToChannels(item);}} else { this.channels = null;} return (A) this;
  }
  public A withChannels(java.lang.String... channels) {
    if (this.channels != null) {this.channels.clear();}
    if (channels != null) {for (java.lang.String item :channels){ this.addToChannels(item);}} return (A) this;
  }
  public java.lang.Boolean hasChannels() {
    return channels != null && !channels.isEmpty();
  }
  public java.lang.String getImage() {
    return this.image;
  }
  public A withImage(java.lang.String image) {
    this.image=image; return (A) this;
  }
  public java.lang.Boolean hasImage() {
    return this.image != null;
  }
  public java.lang.String getUrl() {
    return this.url;
  }
  public A withUrl(java.lang.String url) {
    this.url=url; return (A) this;
  }
  public java.lang.Boolean hasUrl() {
    return this.url != null;
  }
  public java.lang.String getVersion() {
    return this.version;
  }
  public A withVersion(java.lang.String version) {
    this.version=version; return (A) this;
  }
  public java.lang.Boolean hasVersion() {
    return this.version != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ReleaseFluentImpl that = (ReleaseFluentImpl) o;
    if (channels != null ? !channels.equals(that.channels) :that.channels != null) return false;
    if (image != null ? !image.equals(that.image) :that.image != null) return false;
    if (url != null ? !url.equals(that.url) :that.url != null) return false;
    if (version != null ? !version.equals(that.version) :that.version != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(channels,  image,  url,  version,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (channels != null && !channels.isEmpty()) { sb.append("channels:"); sb.append(channels + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}