package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Status;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RepositoryImportStatusFluentImpl<A extends RepositoryImportStatusFluent<A>> extends BaseFluent<A> implements RepositoryImportStatusFluent<A>{
  public RepositoryImportStatusFluentImpl() {
  }
  public RepositoryImportStatusFluentImpl(io.fabric8.openshift.api.model.RepositoryImportStatus instance) {
    this.withAdditionalTags(instance.getAdditionalTags()); 
    this.withImages(instance.getImages()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> additionalTags = new ArrayList<java.lang.String>();
  private java.util.ArrayList<ImageImportStatusBuilder> images = new java.util.ArrayList<ImageImportStatusBuilder>();
  private Status status;
  private Map<java.lang.String,Object> additionalProperties;
  public A addToAdditionalTags(Integer index,java.lang.String item) {
    if (this.additionalTags == null) {this.additionalTags = new java.util.ArrayList<java.lang.String>();}
    this.additionalTags.add(index, item);
    return (A)this;
  }
  public A setToAdditionalTags(java.lang.Integer index,java.lang.String item) {
    if (this.additionalTags == null) {this.additionalTags = new java.util.ArrayList<java.lang.String>();}
    this.additionalTags.set(index, item); return (A)this;
  }
  public A addToAdditionalTags(java.lang.String... items) {
    if (this.additionalTags == null) {this.additionalTags = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.additionalTags.add(item);} return (A)this;
  }
  public A addAllToAdditionalTags(Collection<java.lang.String> items) {
    if (this.additionalTags == null) {this.additionalTags = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.additionalTags.add(item);} return (A)this;
  }
  public A removeFromAdditionalTags(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.additionalTags!= null){ this.additionalTags.remove(item);}} return (A)this;
  }
  public A removeAllFromAdditionalTags(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.additionalTags!= null){ this.additionalTags.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getAdditionalTags() {
    return this.additionalTags;
  }
  public java.lang.String getAdditionalTag(java.lang.Integer index) {
    return this.additionalTags.get(index);
  }
  public java.lang.String getFirstAdditionalTag() {
    return this.additionalTags.get(0);
  }
  public java.lang.String getLastAdditionalTag() {
    return this.additionalTags.get(additionalTags.size() - 1);
  }
  public java.lang.String getMatchingAdditionalTag(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: additionalTags) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAdditionalTag(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: additionalTags) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAdditionalTags(java.util.List<java.lang.String> additionalTags) {
    if (additionalTags != null) {this.additionalTags = new java.util.ArrayList(); for (java.lang.String item : additionalTags){this.addToAdditionalTags(item);}} else { this.additionalTags = null;} return (A) this;
  }
  public A withAdditionalTags(java.lang.String... additionalTags) {
    if (this.additionalTags != null) {this.additionalTags.clear();}
    if (additionalTags != null) {for (java.lang.String item :additionalTags){ this.addToAdditionalTags(item);}} return (A) this;
  }
  public java.lang.Boolean hasAdditionalTags() {
    return additionalTags != null && !additionalTags.isEmpty();
  }
  public A addToImages(java.lang.Integer index,io.fabric8.openshift.api.model.ImageImportStatus item) {
    if (this.images == null) {this.images = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageImportStatusBuilder>();}
    io.fabric8.openshift.api.model.ImageImportStatusBuilder builder = new io.fabric8.openshift.api.model.ImageImportStatusBuilder(item);_visitables.get("images").add(index >= 0 ? index : _visitables.get("images").size(), builder);this.images.add(index >= 0 ? index : images.size(), builder); return (A)this;
  }
  public A setToImages(java.lang.Integer index,io.fabric8.openshift.api.model.ImageImportStatus item) {
    if (this.images == null) {this.images = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageImportStatusBuilder>();}
    io.fabric8.openshift.api.model.ImageImportStatusBuilder builder = new io.fabric8.openshift.api.model.ImageImportStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("images").size()) { _visitables.get("images").add(builder); } else { _visitables.get("images").set(index, builder);}
    if (index < 0 || index >= images.size()) { images.add(builder); } else { images.set(index, builder);}
     return (A)this;
  }
  public A addToImages(io.fabric8.openshift.api.model.ImageImportStatus... items) {
    if (this.images == null) {this.images = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageImportStatusBuilder>();}
    for (io.fabric8.openshift.api.model.ImageImportStatus item : items) {io.fabric8.openshift.api.model.ImageImportStatusBuilder builder = new io.fabric8.openshift.api.model.ImageImportStatusBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  public A addAllToImages(java.util.Collection<io.fabric8.openshift.api.model.ImageImportStatus> items) {
    if (this.images == null) {this.images = new java.util.ArrayList<io.fabric8.openshift.api.model.ImageImportStatusBuilder>();}
    for (io.fabric8.openshift.api.model.ImageImportStatus item : items) {io.fabric8.openshift.api.model.ImageImportStatusBuilder builder = new io.fabric8.openshift.api.model.ImageImportStatusBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  public A removeFromImages(io.fabric8.openshift.api.model.ImageImportStatus... items) {
    for (io.fabric8.openshift.api.model.ImageImportStatus item : items) {io.fabric8.openshift.api.model.ImageImportStatusBuilder builder = new io.fabric8.openshift.api.model.ImageImportStatusBuilder(item);_visitables.get("images").remove(builder);if (this.images != null) {this.images.remove(builder);}} return (A)this;
  }
  public A removeAllFromImages(java.util.Collection<io.fabric8.openshift.api.model.ImageImportStatus> items) {
    for (io.fabric8.openshift.api.model.ImageImportStatus item : items) {io.fabric8.openshift.api.model.ImageImportStatusBuilder builder = new io.fabric8.openshift.api.model.ImageImportStatusBuilder(item);_visitables.get("images").remove(builder);if (this.images != null) {this.images.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImages(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageImportStatusBuilder> predicate) {
    if (images == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.ImageImportStatusBuilder> each = images.iterator();
    final List visitables = _visitables.get("images");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.ImageImportStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImages instead.
   * @return The buildable object.
   */
  @Deprecated
  public java.util.List<io.fabric8.openshift.api.model.ImageImportStatus> getImages() {
    return images != null ? build(images) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.ImageImportStatus> buildImages() {
    return images != null ? build(images) : null;
  }
  public io.fabric8.openshift.api.model.ImageImportStatus buildImage(java.lang.Integer index) {
    return this.images.get(index).build();
  }
  public io.fabric8.openshift.api.model.ImageImportStatus buildFirstImage() {
    return this.images.get(0).build();
  }
  public io.fabric8.openshift.api.model.ImageImportStatus buildLastImage() {
    return this.images.get(images.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.ImageImportStatus buildMatchingImage(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageImportStatusBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ImageImportStatusBuilder item: images) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingImage(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageImportStatusBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ImageImportStatusBuilder item: images) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImages(java.util.List<io.fabric8.openshift.api.model.ImageImportStatus> images) {
    if (this.images != null) { _visitables.get("images").removeAll(this.images);}
    if (images != null) {this.images = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.ImageImportStatus item : images){this.addToImages(item);}} else { this.images = null;} return (A) this;
  }
  public A withImages(io.fabric8.openshift.api.model.ImageImportStatus... images) {
    if (this.images != null) {this.images.clear();}
    if (images != null) {for (io.fabric8.openshift.api.model.ImageImportStatus item :images){ this.addToImages(item);}} return (A) this;
  }
  public java.lang.Boolean hasImages() {
    return images != null && !images.isEmpty();
  }
  public RepositoryImportStatusFluent.ImagesNested<A> addNewImage() {
    return new RepositoryImportStatusFluentImpl.ImagesNestedImpl();
  }
  public io.fabric8.openshift.api.model.RepositoryImportStatusFluent.ImagesNested<A> addNewImageLike(io.fabric8.openshift.api.model.ImageImportStatus item) {
    return new RepositoryImportStatusFluentImpl.ImagesNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.RepositoryImportStatusFluent.ImagesNested<A> setNewImageLike(java.lang.Integer index,io.fabric8.openshift.api.model.ImageImportStatus item) {
    return new io.fabric8.openshift.api.model.RepositoryImportStatusFluentImpl.ImagesNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.RepositoryImportStatusFluent.ImagesNested<A> editImage(java.lang.Integer index) {
    if (images.size() <= index) throw new RuntimeException("Can't edit images. Index exceeds size.");
    return setNewImageLike(index, buildImage(index));
  }
  public io.fabric8.openshift.api.model.RepositoryImportStatusFluent.ImagesNested<A> editFirstImage() {
    if (images.size() == 0) throw new RuntimeException("Can't edit first images. The list is empty.");
    return setNewImageLike(0, buildImage(0));
  }
  public io.fabric8.openshift.api.model.RepositoryImportStatusFluent.ImagesNested<A> editLastImage() {
    int index = images.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last images. The list is empty.");
    return setNewImageLike(index, buildImage(index));
  }
  public io.fabric8.openshift.api.model.RepositoryImportStatusFluent.ImagesNested<A> editMatchingImage(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageImportStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<images.size();i++) { 
    if (predicate.test(images.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching images. No match found.");
    return setNewImageLike(index, buildImage(index));
  }
  public io.fabric8.kubernetes.api.model.Status getStatus() {
    return this.status;
  }
  public A withStatus(io.fabric8.kubernetes.api.model.Status status) {
    this.status=status; return (A) this;
  }
  public java.lang.Boolean hasStatus() {
    return this.status != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RepositoryImportStatusFluentImpl that = (RepositoryImportStatusFluentImpl) o;
    if (additionalTags != null ? !additionalTags.equals(that.additionalTags) :that.additionalTags != null) return false;
    if (images != null ? !images.equals(that.images) :that.images != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(additionalTags,  images,  status,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalTags != null && !additionalTags.isEmpty()) { sb.append("additionalTags:"); sb.append(additionalTags + ","); }
    if (images != null && !images.isEmpty()) { sb.append("images:"); sb.append(images + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ImagesNestedImpl<N> extends ImageImportStatusFluentImpl<RepositoryImportStatusFluent.ImagesNested<N>> implements io.fabric8.openshift.api.model.RepositoryImportStatusFluent.ImagesNested<N>,Nested<N>{
    ImagesNestedImpl(java.lang.Integer index,ImageImportStatus item) {
      this.index = index;
      this.builder = new ImageImportStatusBuilder(this, item);
    }
    ImagesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ImageImportStatusBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageImportStatusBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) RepositoryImportStatusFluentImpl.this.setToImages(index,builder.build());
    }
    public N endImage() {
      return and();
    }
    
  }
  
}