package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RoleBindingRestrictionSpecBuilder extends RoleBindingRestrictionSpecFluentImpl<RoleBindingRestrictionSpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.RoleBindingRestrictionSpec,io.fabric8.openshift.api.model.RoleBindingRestrictionSpecBuilder>{
  public RoleBindingRestrictionSpecBuilder() {
    this(false);
  }
  public RoleBindingRestrictionSpecBuilder(Boolean validationEnabled) {
    this(new RoleBindingRestrictionSpec(), validationEnabled);
  }
  public RoleBindingRestrictionSpecBuilder(RoleBindingRestrictionSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public RoleBindingRestrictionSpecBuilder(io.fabric8.openshift.api.model.RoleBindingRestrictionSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RoleBindingRestrictionSpec(), validationEnabled);
  }
  public RoleBindingRestrictionSpecBuilder(io.fabric8.openshift.api.model.RoleBindingRestrictionSpecFluent<?> fluent,io.fabric8.openshift.api.model.RoleBindingRestrictionSpec instance) {
    this(fluent, instance, false);
  }
  public RoleBindingRestrictionSpecBuilder(io.fabric8.openshift.api.model.RoleBindingRestrictionSpecFluent<?> fluent,io.fabric8.openshift.api.model.RoleBindingRestrictionSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGrouprestriction(instance.getGrouprestriction()); 
    fluent.withServiceaccountrestriction(instance.getServiceaccountrestriction()); 
    fluent.withUserrestriction(instance.getUserrestriction()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RoleBindingRestrictionSpecBuilder(io.fabric8.openshift.api.model.RoleBindingRestrictionSpec instance) {
    this(instance,false);
  }
  public RoleBindingRestrictionSpecBuilder(io.fabric8.openshift.api.model.RoleBindingRestrictionSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withGrouprestriction(instance.getGrouprestriction()); 
    this.withServiceaccountrestriction(instance.getServiceaccountrestriction()); 
    this.withUserrestriction(instance.getUserrestriction()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.RoleBindingRestrictionSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.RoleBindingRestrictionSpec build() {
    RoleBindingRestrictionSpec buildable = new RoleBindingRestrictionSpec(fluent.getGrouprestriction(),fluent.getServiceaccountrestriction(),fluent.getUserrestriction());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}