package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RollingDeploymentStrategyParamsBuilder extends RollingDeploymentStrategyParamsFluentImpl<RollingDeploymentStrategyParamsBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.RollingDeploymentStrategyParams,io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsBuilder>{
  public RollingDeploymentStrategyParamsBuilder() {
    this(false);
  }
  public RollingDeploymentStrategyParamsBuilder(Boolean validationEnabled) {
    this(new RollingDeploymentStrategyParams(), validationEnabled);
  }
  public RollingDeploymentStrategyParamsBuilder(RollingDeploymentStrategyParamsFluent<?> fluent) {
    this(fluent, false);
  }
  public RollingDeploymentStrategyParamsBuilder(io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RollingDeploymentStrategyParams(), validationEnabled);
  }
  public RollingDeploymentStrategyParamsBuilder(io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent<?> fluent,io.fabric8.openshift.api.model.RollingDeploymentStrategyParams instance) {
    this(fluent, instance, false);
  }
  public RollingDeploymentStrategyParamsBuilder(io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent<?> fluent,io.fabric8.openshift.api.model.RollingDeploymentStrategyParams instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withIntervalSeconds(instance.getIntervalSeconds()); 
    fluent.withMaxSurge(instance.getMaxSurge()); 
    fluent.withMaxUnavailable(instance.getMaxUnavailable()); 
    fluent.withPost(instance.getPost()); 
    fluent.withPre(instance.getPre()); 
    fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); 
    fluent.withUpdatePeriodSeconds(instance.getUpdatePeriodSeconds()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RollingDeploymentStrategyParamsBuilder(io.fabric8.openshift.api.model.RollingDeploymentStrategyParams instance) {
    this(instance,false);
  }
  public RollingDeploymentStrategyParamsBuilder(io.fabric8.openshift.api.model.RollingDeploymentStrategyParams instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withIntervalSeconds(instance.getIntervalSeconds()); 
    this.withMaxSurge(instance.getMaxSurge()); 
    this.withMaxUnavailable(instance.getMaxUnavailable()); 
    this.withPost(instance.getPost()); 
    this.withPre(instance.getPre()); 
    this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
    this.withUpdatePeriodSeconds(instance.getUpdatePeriodSeconds()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.RollingDeploymentStrategyParams build() {
    RollingDeploymentStrategyParams buildable = new RollingDeploymentStrategyParams(fluent.getIntervalSeconds(),fluent.getMaxSurge(),fluent.getMaxUnavailable(),fluent.getPost(),fluent.getPre(),fluent.getTimeoutSeconds(),fluent.getUpdatePeriodSeconds());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}