package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RouteIngressBuilder extends RouteIngressFluentImpl<RouteIngressBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.RouteIngress,io.fabric8.openshift.api.model.RouteIngressBuilder>{
  public RouteIngressBuilder() {
    this(false);
  }
  public RouteIngressBuilder(Boolean validationEnabled) {
    this(new RouteIngress(), validationEnabled);
  }
  public RouteIngressBuilder(RouteIngressFluent<?> fluent) {
    this(fluent, false);
  }
  public RouteIngressBuilder(io.fabric8.openshift.api.model.RouteIngressFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RouteIngress(), validationEnabled);
  }
  public RouteIngressBuilder(io.fabric8.openshift.api.model.RouteIngressFluent<?> fluent,io.fabric8.openshift.api.model.RouteIngress instance) {
    this(fluent, instance, false);
  }
  public RouteIngressBuilder(io.fabric8.openshift.api.model.RouteIngressFluent<?> fluent,io.fabric8.openshift.api.model.RouteIngress instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withHost(instance.getHost()); 
    fluent.withRouterCanonicalHostname(instance.getRouterCanonicalHostname()); 
    fluent.withRouterName(instance.getRouterName()); 
    fluent.withWildcardPolicy(instance.getWildcardPolicy()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RouteIngressBuilder(io.fabric8.openshift.api.model.RouteIngress instance) {
    this(instance,false);
  }
  public RouteIngressBuilder(io.fabric8.openshift.api.model.RouteIngress instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withHost(instance.getHost()); 
    this.withRouterCanonicalHostname(instance.getRouterCanonicalHostname()); 
    this.withRouterName(instance.getRouterName()); 
    this.withWildcardPolicy(instance.getWildcardPolicy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.RouteIngressFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.RouteIngress build() {
    RouteIngress buildable = new RouteIngress(fluent.getConditions(),fluent.getHost(),fluent.getRouterCanonicalHostname(),fluent.getRouterName(),fluent.getWildcardPolicy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}