package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RoutePortBuilder extends RoutePortFluentImpl<RoutePortBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.RoutePort,io.fabric8.openshift.api.model.RoutePortBuilder>{
  public RoutePortBuilder() {
    this(false);
  }
  public RoutePortBuilder(Boolean validationEnabled) {
    this(new RoutePort(), validationEnabled);
  }
  public RoutePortBuilder(RoutePortFluent<?> fluent) {
    this(fluent, false);
  }
  public RoutePortBuilder(io.fabric8.openshift.api.model.RoutePortFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RoutePort(), validationEnabled);
  }
  public RoutePortBuilder(io.fabric8.openshift.api.model.RoutePortFluent<?> fluent,io.fabric8.openshift.api.model.RoutePort instance) {
    this(fluent, instance, false);
  }
  public RoutePortBuilder(io.fabric8.openshift.api.model.RoutePortFluent<?> fluent,io.fabric8.openshift.api.model.RoutePort instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withTargetPort(instance.getTargetPort()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RoutePortBuilder(io.fabric8.openshift.api.model.RoutePort instance) {
    this(instance,false);
  }
  public RoutePortBuilder(io.fabric8.openshift.api.model.RoutePort instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withTargetPort(instance.getTargetPort()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.RoutePortFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.RoutePort build() {
    RoutePort buildable = new RoutePort(fluent.getTargetPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}