package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SecretBuildSourceFluentImpl<A extends SecretBuildSourceFluent<A>> extends BaseFluent<A> implements SecretBuildSourceFluent<A>{
  public SecretBuildSourceFluentImpl() {
  }
  public SecretBuildSourceFluentImpl(io.fabric8.openshift.api.model.SecretBuildSource instance) {
    this.withDestinationDir(instance.getDestinationDir()); 
    this.withSecret(instance.getSecret()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String destinationDir;
  private LocalObjectReferenceBuilder secret;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getDestinationDir() {
    return this.destinationDir;
  }
  public A withDestinationDir(java.lang.String destinationDir) {
    this.destinationDir=destinationDir; return (A) this;
  }
  public Boolean hasDestinationDir() {
    return this.destinationDir != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public io.fabric8.kubernetes.api.model.LocalObjectReference buildSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public A withSecret(io.fabric8.kubernetes.api.model.LocalObjectReference secret) {
    _visitables.get("secret").remove(this.secret);
    if (secret!=null){ this.secret= new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(secret); _visitables.get("secret").add(this.secret);} return (A) this;
  }
  public java.lang.Boolean hasSecret() {
    return this.secret != null;
  }
  public A withNewSecret(java.lang.String name) {
    return (A)withSecret(new LocalObjectReference(name));
  }
  public SecretBuildSourceFluent.SecretNested<A> withNewSecret() {
    return new SecretBuildSourceFluentImpl.SecretNestedImpl();
  }
  public io.fabric8.openshift.api.model.SecretBuildSourceFluent.SecretNested<A> withNewSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return new SecretBuildSourceFluentImpl.SecretNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.SecretBuildSourceFluent.SecretNested<A> editSecret() {
    return withNewSecretLike(getSecret());
  }
  public io.fabric8.openshift.api.model.SecretBuildSourceFluent.SecretNested<A> editOrNewSecret() {
    return withNewSecretLike(getSecret() != null ? getSecret(): new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.SecretBuildSourceFluent.SecretNested<A> editOrNewSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return withNewSecretLike(getSecret() != null ? getSecret(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SecretBuildSourceFluentImpl that = (SecretBuildSourceFluentImpl) o;
    if (destinationDir != null ? !destinationDir.equals(that.destinationDir) :that.destinationDir != null) return false;
    if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(destinationDir,  secret,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (destinationDir != null) { sb.append("destinationDir:"); sb.append(destinationDir + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class SecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<SecretBuildSourceFluent.SecretNested<N>> implements io.fabric8.openshift.api.model.SecretBuildSourceFluent.SecretNested<N>,Nested<N>{
    SecretNestedImpl(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this, item);
    }
    SecretNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) SecretBuildSourceFluentImpl.this.withSecret(builder.build());
    }
    public N endSecret() {
      return and();
    }
    
  }
  
}